/*
 * Decompiled with CFR 0.152.
 */
package com.google.summit;

import com.google.summit.SummitAST;
import com.google.summit.ast.CompilationUnit;
import com.google.summit.translation.Translate;
import io.github.apexdevtools.apexparser.ApexLexer;
import io.github.apexdevtools.apexparser.ApexParser;
import io.github.apexdevtools.apexparser.CaseInsensitiveInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006J)\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0014J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/google/summit/SummitAST;", "", "()V", "STRING_INPUT", "", "determineCompilationType", "Lcom/google/summit/SummitAST$CompilationType;", "charStream", "Lorg/antlr/v4/runtime/CharStream;", "isApexClassFile", "", "path", "Ljava/nio/file/Path;", "isApexSourceFile", "isApexTriggerFile", "parseAndTranslate", "Lcom/google/summit/ast/CompilationUnit;", "string", "type", "name", "parseAndTranslate$_maven_lib", "CompilationType", "ParseException", "SyntaxErrorListener", "-maven_lib"})
public final class SummitAST {
    @NotNull
    public static final SummitAST INSTANCE = new SummitAST();
    @NotNull
    private static final String STRING_INPUT = "<str>";

    private SummitAST() {
    }

    @Nullable
    public final CompilationUnit parseAndTranslate(@NotNull Path path) throws ParseException {
        CompilationType compilationType;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = ((Object)path).toString();
        if (this.isApexClassFile(path)) {
            compilationType = CompilationType.CLASS;
        } else if (this.isApexTriggerFile(path)) {
            compilationType = CompilationType.TRIGGER;
        } else {
            throw new IllegalArgumentException("Unexpected file type");
        }
        CharStream charStream = CharStreams.fromPath((Path)path);
        Intrinsics.checkNotNullExpressionValue((Object)charStream, (String)"fromPath(path)");
        return this.parseAndTranslate$_maven_lib(string, compilationType, charStream);
    }

    @Nullable
    public final CompilationUnit parseAndTranslate(@NotNull String string, @Nullable CompilationType type) throws ParseException {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        CodePointCharStream codePointCharStream = CharStreams.fromString((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)codePointCharStream, (String)"fromString(string)");
        return this.parseAndTranslate$_maven_lib(STRING_INPUT, type, (CharStream)codePointCharStream);
    }

    @Nullable
    public final CompilationUnit parseAndTranslate(@NotNull String name, @NotNull String string, @Nullable CompilationType type) throws ParseException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        CodePointCharStream codePointCharStream = CharStreams.fromString((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)codePointCharStream, (String)"fromString(string)");
        return this.parseAndTranslate$_maven_lib(name, type, (CharStream)codePointCharStream);
    }

    @Nullable
    public final CompilationUnit parseAndTranslate$_maven_lib(@NotNull String name, @Nullable CompilationType type, @NotNull CharStream charStream) {
        ParserRuleContext parserRuleContext;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)charStream, (String)"charStream");
        ApexLexer lexer = new ApexLexer((CharStream)new CaseInsensitiveInputStream(charStream));
        CommonTokenStream tokens2 = new CommonTokenStream((TokenSource)lexer);
        ApexParser parser = new ApexParser((TokenStream)tokens2);
        SyntaxErrorListener errorCounter = new SyntaxErrorListener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorCounter);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorCounter);
        CompilationType compilationType = type;
        if (compilationType == null) {
            compilationType = this.determineCompilationType(charStream);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[compilationType.ordinal()]) {
            case 1: {
                parserRuleContext = (ParserRuleContext)parser.compilationUnit();
                break;
            }
            case 2: {
                parserRuleContext = (ParserRuleContext)parser.triggerUnit();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ParserRuleContext tree = parserRuleContext;
        if (errorCounter.getNumErrors() > 0) {
            throw new ParseException("Failed to parse " + name + ":\n" + errorCounter.errorMessages(), null, 2, null);
        }
        try {
            Translate translator = new Translate(name, (TokenStream)tokens2);
            Intrinsics.checkNotNullExpressionValue((Object)tree, (String)"tree");
            CompilationUnit ast = translator.translate(tree);
            return ast;
        }
        catch (Translate.TranslationException e) {
            throw new ParseException("Failed to translate " + name, e);
        }
    }

    private final CompilationType determineCompilationType(CharStream charStream) {
        charStream.seek(0);
        CompilationType type = SummitAST.determineCompilationType$findType(charStream);
        charStream.seek(0);
        CompilationType compilationType = type;
        if (compilationType == null) {
            compilationType = CompilationType.CLASS;
        }
        return compilationType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isApexClassFile(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0])) return false;
        String string = ((Object)path).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (!StringsKt.endsWith$default((String)string, (String)".cls", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isApexTriggerFile(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0])) return false;
        String string = ((Object)path).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (!StringsKt.endsWith$default((String)string, (String)".trigger", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public final boolean isApexSourceFile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.isApexClassFile(path) || this.isApexTriggerFile(path);
    }

    private static final CompilationType determineCompilationType$findType(CharStream $charStream) {
        Sequence tokens2;
        ApexLexer lexer = new ApexLexer((CharStream)new CaseInsensitiveInputStream($charStream));
        lexer.removeErrorListeners();
        Sequence $this$forEach$iv = tokens2 = SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<Token>(lexer){
            final /* synthetic */ ApexLexer $lexer;
            {
                this.$lexer = $lexer;
                super(0);
            }

            @Nullable
            public final Token invoke() {
                return this.$lexer.nextToken();
            }
        })), (Function1)determineCompilationType.findType.tokens.2.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Token token = (Token)element$iv;
            boolean bl = false;
            switch (token.getType()) {
                case 6: 
                case 11: 
                case 23: {
                    return CompilationType.CLASS;
                }
                case 43: {
                    return CompilationType.TRIGGER;
                }
            }
        }
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/google/summit/SummitAST$CompilationType;", "", "(Ljava/lang/String;I)V", "CLASS", "TRIGGER", "-maven_lib"})
    public static final class CompilationType
    extends Enum<CompilationType> {
        public static final /* enum */ CompilationType CLASS = new CompilationType();
        public static final /* enum */ CompilationType TRIGGER = new CompilationType();
        private static final /* synthetic */ CompilationType[] $VALUES;

        public static CompilationType[] values() {
            return (CompilationType[])$VALUES.clone();
        }

        public static CompilationType valueOf(String value) {
            return Enum.valueOf(CompilationType.class, value);
        }

        static {
            $VALUES = compilationTypeArray = new CompilationType[]{CompilationType.CLASS, CompilationType.TRIGGER};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/google/summit/SummitAST$ParseException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "msg", "", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "-maven_lib"})
    public static final class ParseException
    extends Exception {
        public ParseException(@NotNull String msg, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            super(msg, cause);
        }

        public /* synthetic */ ParseException(String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0011\u001a\u00020\u0005JD\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016R*\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/google/summit/SummitAST$SyntaxErrorListener;", "Lorg/antlr/v4/runtime/BaseErrorListener;", "()V", "errors", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getErrors", "()Ljava/util/ArrayList;", "setErrors", "(Ljava/util/ArrayList;)V", "numErrors", "", "getNumErrors", "()I", "setNumErrors", "(I)V", "errorMessages", "syntaxError", "", "recognizer", "Lorg/antlr/v4/runtime/Recognizer;", "offendingSymbol", "", "line", "charPositionInLine", "msg", "e", "Lorg/antlr/v4/runtime/RecognitionException;", "-maven_lib"})
    private static final class SyntaxErrorListener
    extends BaseErrorListener {
        private int numErrors;
        @NotNull
        private ArrayList<String> errors = new ArrayList();

        public final int getNumErrors() {
            return this.numErrors;
        }

        public final void setNumErrors(int n) {
            this.numErrors = n;
        }

        @NotNull
        public final ArrayList<String> getErrors() {
            return this.errors;
        }

        public final void setErrors(@NotNull ArrayList<String> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
            this.errors = arrayList;
        }

        public void syntaxError(@NotNull Recognizer<?, ?> recognizer, @Nullable Object offendingSymbol, int line, int charPositionInLine, @NotNull String msg, @Nullable RecognitionException e) {
            Intrinsics.checkNotNullParameter(recognizer, (String)"recognizer");
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            ++this.numErrors;
            this.errors.add("Syntax error at " + line + ':' + charPositionInLine + ": " + msg);
        }

        @NotNull
        public final String errorMessages() {
            return CollectionsKt.joinToString$default((Iterable)this.errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompilationType.values().length];
            try {
                nArray[CompilationType.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilationType.TRIGGER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

