/*
 * Decompiled with CFR 0.152.
 */
package com.google.summit.ast;

import com.google.summit.ast.Node;
import com.google.summit.ast.SourceLocation;
import com.google.summit.ast.traversal.Visitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\tH&J\b\u0010\n\u001a\u00020\u000bH&J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/google/summit/ast/Node;", "", "()V", "parent", "getParent", "()Lcom/google/summit/ast/Node;", "setParent", "(Lcom/google/summit/ast/Node;)V", "getChildren", "", "getSourceLocation", "Lcom/google/summit/ast/SourceLocation;", "walkSubtree", "", "visitor", "Lcom/google/summit/ast/traversal/Visitor;", "Companion", "-maven_lib"})
public abstract class Node {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private transient Node parent;
    @NotNull
    private static ThreadLocal<Integer> totalCountThreadLocal;

    public Node() {
        Companion companion = Companion;
        companion.setTotalCount(companion.getTotalCount() + 1);
        companion.getTotalCount();
    }

    @NotNull
    public abstract SourceLocation getSourceLocation();

    public final void walkSubtree(@NotNull Visitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Node.walkSubtree$recurseOnNode(this, visitor);
    }

    @NotNull
    public abstract List<Node> getChildren();

    @Nullable
    public final Node getParent() {
        return this.parent;
    }

    public final void setParent(@Nullable Node node) {
        this.parent = node;
    }

    private static final boolean walkSubtree$recurseOnNode(Node node, Visitor visitor) {
        if (visitor.stopAt(node)) {
            return true;
        }
        if (!visitor.skipBelow(node)) {
            for (Node child : node.getChildren()) {
                if (!Node.walkSubtree$recurseOnNode(child, visitor)) continue;
                return true;
            }
        }
        visitor.visit(node);
        return false;
    }

    static {
        ThreadLocal threadLocal = ThreadLocal.withInitial(Companion.totalCountThreadLocal.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"withInitial { 0 }");
        totalCountThreadLocal = threadLocal;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eR$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/google/summit/ast/Node$Companion;", "", "()V", "value", "", "totalCount", "getTotalCount", "()I", "setTotalCount", "(I)V", "totalCountThreadLocal", "Ljava/lang/ThreadLocal;", "setNodeParents", "node", "Lcom/google/summit/ast/Node;", "-maven_lib"})
    public static final class Companion {
        private Companion() {
        }

        public final int getTotalCount() {
            Object t = totalCountThreadLocal.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"totalCountThreadLocal.get()");
            return ((Number)t).intValue();
        }

        public final void setTotalCount(int value) {
            totalCountThreadLocal.set(value);
        }

        public final int setNodeParents(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            int reachableCount = 1;
            for (Node child : node.getChildren()) {
                if (child.getParent() != null) {
                    throw new Exception("Nodes should have a unique parent, but " + child + " has " + child.getParent() + " and " + node);
                }
                child.setParent(node);
                reachableCount += this.setNodeParents(child);
            }
            return reachableCount;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

