/*
 * Decompiled with CFR 0.152.
 */
package com.google.summit.ast;

import com.google.summit.ast.Identifier;
import com.google.summit.ast.Node;
import com.google.summit.ast.PrintableAsCodeString;
import com.google.summit.ast.SourceLocation;
import com.google.summit.ast.TypeRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0002\u0015\u0016B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/google/summit/ast/TypeRef;", "Lcom/google/summit/ast/Node;", "Lcom/google/summit/ast/PrintableAsCodeString;", "components", "", "Lcom/google/summit/ast/TypeRef$Component;", "arrayNesting", "", "(Ljava/util/List;I)V", "getArrayNesting", "()I", "getComponents", "()Ljava/util/List;", "asCodeString", "", "asTypeErasedString", "getChildren", "getSourceLocation", "Lcom/google/summit/ast/SourceLocation;", "isVoid", "", "Companion", "Component", "-maven_lib"})
public final class TypeRef
extends Node
implements PrintableAsCodeString {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Component> components;
    private final int arrayNesting;

    public TypeRef(@NotNull List<Component> components, int arrayNesting) {
        Intrinsics.checkNotNullParameter(components, (String)"components");
        this.components = components;
        this.arrayNesting = arrayNesting;
    }

    @NotNull
    public final List<Component> getComponents() {
        return this.components;
    }

    public final int getArrayNesting() {
        return this.arrayNesting;
    }

    public final boolean isVoid() {
        return this.components.isEmpty();
    }

    @Override
    @NotNull
    public String asCodeString() {
        return this.isVoid() ? "void" : CollectionsKt.joinToString$default((Iterable)this.components, (CharSequence)".", null, null, (int)0, null, (Function1)asCodeString.1.INSTANCE, (int)30, null) + StringsKt.repeat((CharSequence)"[]", (int)this.arrayNesting);
    }

    @NotNull
    public final String asTypeErasedString() {
        return this.isVoid() ? "void" : CollectionsKt.joinToString$default((Iterable)this.components, (CharSequence)".", null, null, (int)0, null, (Function1)asTypeErasedString.1.INSTANCE, (int)30, null) + StringsKt.repeat((CharSequence)"[]", (int)this.arrayNesting);
    }

    @Override
    @NotNull
    public SourceLocation getSourceLocation() {
        return SourceLocation.Companion.getUNKNOWN();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Node> getChildren() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = this.components;
        Function1 transform$iv = getChildren.1.INSTANCE;
        boolean $i$f$flatMap = false;
        void var4_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable list$iv$iv = (Iterable)transform$iv.invoke(element$iv$iv);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0004J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/google/summit/ast/TypeRef$Companion;", "", "()V", "createFromQualifiedName", "Lcom/google/summit/ast/TypeRef;", "qualifiedName", "", "createFromUnqualifiedName", "unqualifiedName", "Lcom/google/summit/ast/Identifier;", "createVoid", "qualifiedNameToComponentList", "", "Lcom/google/summit/ast/TypeRef$Component;", "-maven_lib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TypeRef createVoid() {
            return new TypeRef(CollectionsKt.emptyList(), 0);
        }

        @NotNull
        public final TypeRef createFromUnqualifiedName(@NotNull Identifier unqualifiedName) {
            Intrinsics.checkNotNullParameter((Object)unqualifiedName, (String)"unqualifiedName");
            return new TypeRef(CollectionsKt.listOf((Object)new Component(unqualifiedName, CollectionsKt.emptyList())), 0);
        }

        @NotNull
        public final TypeRef createFromQualifiedName(@NotNull String qualifiedName) {
            Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
            return new TypeRef(this.qualifiedNameToComponentList(qualifiedName), 0);
        }

        /*
         * WARNING - void declaration
         */
        private final List<Component> qualifiedNameToComponentList(String qualifiedName) {
            void $this$mapTo$iv$iv;
            char[] cArray = new char[]{'.'};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)qualifiedName, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Component(new Identifier((String)it, SourceLocation.Companion.getUNKNOWN()), CollectionsKt.emptyList()));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\b\u0010\u0017\u001a\u00020\rH\u0002J\t\u0010\u0018\u001a\u00020\rH\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/google/summit/ast/TypeRef$Component;", "Lcom/google/summit/ast/PrintableAsCodeString;", "id", "Lcom/google/summit/ast/Identifier;", "args", "", "Lcom/google/summit/ast/TypeRef;", "(Lcom/google/summit/ast/Identifier;Ljava/util/List;)V", "getArgs", "()Ljava/util/List;", "getId", "()Lcom/google/summit/ast/Identifier;", "asCodeString", "", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "optionalTypeArgumentsAsCodeString", "toString", "-maven_lib"})
    public static final class Component
    implements PrintableAsCodeString {
        @NotNull
        private final Identifier id;
        @NotNull
        private final List<TypeRef> args;

        public Component(@NotNull Identifier id, @NotNull List<TypeRef> args) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            this.id = id;
            this.args = args;
        }

        @NotNull
        public final Identifier getId() {
            return this.id;
        }

        @NotNull
        public final List<TypeRef> getArgs() {
            return this.args;
        }

        @Override
        @NotNull
        public String asCodeString() {
            return this.id.asCodeString() + this.optionalTypeArgumentsAsCodeString();
        }

        private final String optionalTypeArgumentsAsCodeString() {
            return !((Collection)this.args).isEmpty() ? '<' + CollectionsKt.joinToString$default((Iterable)this.args, null, null, null, (int)0, null, (Function1)optionalTypeArgumentsAsCodeString.1.INSTANCE, (int)31, null) + '>' : "";
        }

        @NotNull
        public final Identifier component1() {
            return this.id;
        }

        @NotNull
        public final List<TypeRef> component2() {
            return this.args;
        }

        @NotNull
        public final Component copy(@NotNull Identifier id, @NotNull List<TypeRef> args) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            return new Component(id, args);
        }

        public static /* synthetic */ Component copy$default(Component component, Identifier identifier, List list, int n, Object object) {
            if ((n & 1) != 0) {
                identifier = component.id;
            }
            if ((n & 2) != 0) {
                list = component.args;
            }
            return component.copy(identifier, list);
        }

        @NotNull
        public String toString() {
            return "Component(id=" + this.id + ", args=" + this.args + ')';
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + ((Object)this.args).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Component)) {
                return false;
            }
            Component component = (Component)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)component.id)) {
                return false;
            }
            return Intrinsics.areEqual(this.args, component.args);
        }
    }
}

