/*
 * Decompiled with CFR 0.152.
 */
package io.github.apexdevtools.api;

public abstract class IssueLocation {
    public abstract int startLineNumber();

    public abstract int startCharOffset();

    public abstract int endLineNumber();

    public abstract int endCharOffset();

    public String displayPosition() {
        if (this.startLineNumber() == 1 && this.endLineNumber() == Integer.MAX_VALUE && this.startCharOffset() == 0 && this.endCharOffset() == 0) {
            return "line 1";
        }
        if (this.startLineNumber() == this.endLineNumber()) {
            if (this.startCharOffset() == 0 && this.endCharOffset() == 0) {
                return "line " + this.startLineNumber();
            }
            if (this.startCharOffset() == this.endCharOffset()) {
                return "line " + this.startLineNumber() + " at " + this.startCharOffset();
            }
            return "line " + this.startLineNumber() + " at " + this.startCharOffset() + "-" + this.endCharOffset();
        }
        if (this.startCharOffset() == 0 && this.endCharOffset() == 0) {
            return "line " + this.startLineNumber() + " to " + this.endLineNumber();
        }
        return "line " + this.startLineNumber() + ":" + this.startCharOffset() + " to " + this.endLineNumber() + ":" + this.endCharOffset();
    }

    public boolean contains(int n, int n2) {
        return !(n < this.startLineNumber() || n > this.endLineNumber() || n == this.startLineNumber() && n2 < this.startCharOffset() || n == this.endLineNumber() && n2 > this.endCharOffset());
    }

    public boolean contains(IssueLocation issueLocation) {
        return this.contains(issueLocation.startLineNumber(), issueLocation.startCharOffset()) && this.contains(issueLocation.endLineNumber(), issueLocation.endCharOffset());
    }
}

