/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.util;

import com.google.common.flogger.util.Checks;
import com.google.common.flogger.util.StackGetter;
import com.google.common.flogger.util.ThrowableStackGetter;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class CallerFinder {
    private static final String[] STACK_GETTER_IMPLEMENTATIONS = new String[]{"com.google.common.flogger.util.StackWalkerStackGetter", "com.google.common.flogger.util.JavaLangAccessStackGetter"};
    private static final StackGetter STACK_GETTER = CallerFinder.getBestStackGetter();

    private static StackGetter getBestStackGetter() {
        for (String stackGetterName : STACK_GETTER_IMPLEMENTATIONS) {
            StackGetter stackGetter = CallerFinder.maybeCreateStackGetter(stackGetterName);
            if (stackGetter == null) continue;
            return stackGetter;
        }
        return new ThrowableStackGetter();
    }

    private static StackGetter maybeCreateStackGetter(String className) {
        try {
            return Class.forName(className).asSubclass(StackGetter.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @NullableDecl
    public static StackTraceElement findCallerOf(Class<?> target, int skip) {
        Checks.checkNotNull(target, "target");
        if (skip < 0) {
            throw new IllegalArgumentException("skip count cannot be negative: " + skip);
        }
        return STACK_GETTER.callerOf(target, skip + 1);
    }

    public static StackTraceElement[] getStackForCallerOf(Class<?> target, int maxDepth, int skip) {
        Checks.checkNotNull(target, "target");
        if (maxDepth <= 0 && maxDepth != -1) {
            throw new IllegalArgumentException("invalid maximum depth: " + maxDepth);
        }
        if (skip < 0) {
            throw new IllegalArgumentException("skip count cannot be negative: " + skip);
        }
        return STACK_GETTER.getStackForCaller(target, maxDepth, skip + 1);
    }

    private CallerFinder() {
    }
}

