/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import com.google.summit.ast.CompilationUnit;
import io.github.apexdevtools.api.Issue;
import java.util.Collection;
import java.util.List;
import net.sourceforge.pmd.lang.apex.ApexLanguageProcessor;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClassOrInterface;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexVisitor;
import net.sourceforge.pmd.lang.apex.ast.BaseApexClass;
import net.sourceforge.pmd.lang.apex.multifile.ApexMultifileAnalysis;
import net.sourceforge.pmd.lang.ast.AstInfo;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextRegion;
import net.sourceforge.pmd.reporting.ViolationSuppressor;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ASTApexFile
extends AbstractApexNode.Single<CompilationUnit>
implements RootNode {
    private final AstInfo<ASTApexFile> astInfo;
    private final @NonNull ApexMultifileAnalysis multifileAnalysis;

    ASTApexFile(Parser.ParserTask task, CompilationUnit compilationUnit, Collection<? extends ViolationSuppressor.SuppressionCommentWrapper> suppressMap, @NonNull ApexLanguageProcessor apexLang) {
        super(compilationUnit);
        this.astInfo = new AstInfo(task, (RootNode)this).withSuppressionComments(suppressMap);
        this.multifileAnalysis = apexLang.getMultiFileState();
        this.setRegion(TextRegion.fromOffsetLength((int)0, (int)task.getTextDocument().getLength()));
    }

    public AstInfo<ASTApexFile> getAstInfo() {
        return this.astInfo;
    }

    public ASTUserClassOrInterface<?> getMainNode() {
        return (ASTUserClassOrInterface)this.getChild(0);
    }

    @Override
    public @NonNull ASTApexFile getRoot() {
        return this;
    }

    @Override
    protected <P, R> R acceptApexVisitor(ApexVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public List<Issue> getGlobalIssues() {
        FileId fileId = this.getAstInfo().getTextDocument().getFileId();
        return this.multifileAnalysis.getFileIssues(fileId.getAbsolutePath());
    }

    @Override
    public String getDefiningType() {
        BaseApexClass baseApexClass = (BaseApexClass)this.firstChild(BaseApexClass.class);
        if (baseApexClass != null) {
            return baseApexClass.getQualifiedName().toString();
        }
        return null;
    }
}

