/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.bestpractices;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.apex.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.bestpractices.AbstractApexUnitTestRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import org.apache.commons.lang3.StringUtils;

public class ApexUnitTestClassShouldHaveAssertsRule
extends AbstractApexUnitTestRule {
    private static final Set<String> ASSERT_METHODS = new HashSet<String>();
    private static final PropertyDescriptor<String> ADDITIONAL_ASSERT_METHOD_PATTERN_DESCRIPTOR;
    private Optional<Pattern> compiledAdditionalAssertMethodPattern = null;

    public ApexUnitTestClassShouldHaveAssertsRule() {
        this.definePropertyDescriptor(ADDITIONAL_ASSERT_METHOD_PATTERN_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTMethod node, Object data) {
        if (!this.isTestMethodOrClass(node)) {
            return data;
        }
        return this.checkForAssertStatements(node, data);
    }

    private Object checkForAssertStatements(ApexNode<?> node, Object data) {
        String additionalAssertMethodPattern;
        Pattern compiledPattern;
        List blockStatements = node.descendants(ASTBlockStatement.class).toList();
        ArrayList methodCalls = new ArrayList();
        for (Object blockStatement : blockStatements) {
            methodCalls.addAll(blockStatement.descendants(ASTMethodCallExpression.class).toList());
        }
        boolean isAssertFound = false;
        for (ASTMethodCallExpression methodCallExpression : methodCalls) {
            if (!ASSERT_METHODS.contains(methodCallExpression.getFullMethodName().toLowerCase(Locale.ROOT))) continue;
            isAssertFound = true;
            break;
        }
        if (!isAssertFound && (compiledPattern = this.getCompiledAdditionalAssertMethodPattern(additionalAssertMethodPattern = (String)this.getProperty(ADDITIONAL_ASSERT_METHOD_PATTERN_DESCRIPTOR))) != null) {
            for (ASTMethodCallExpression methodCallExpression : methodCalls) {
                String fullMethodName = methodCallExpression.getFullMethodName();
                if (!compiledPattern.matcher(fullMethodName).matches()) continue;
                isAssertFound = true;
                break;
            }
        }
        if (!isAssertFound) {
            this.asCtx(data).addViolation(node);
        }
        return data;
    }

    private Pattern getCompiledAdditionalAssertMethodPattern(String additionalAssertMethodPattern) {
        if (StringUtils.isNotBlank((CharSequence)additionalAssertMethodPattern) && this.compiledAdditionalAssertMethodPattern == null) {
            try {
                this.compiledAdditionalAssertMethodPattern = Optional.of(Pattern.compile(additionalAssertMethodPattern, 2));
            }
            catch (IllegalArgumentException e) {
                this.compiledAdditionalAssertMethodPattern = Optional.ofNullable(null);
                throw e;
            }
        }
        return this.compiledAdditionalAssertMethodPattern != null ? this.compiledAdditionalAssertMethodPattern.get() : null;
    }

    static {
        ASSERT_METHODS.add("system.assert");
        ASSERT_METHODS.add("system.assertequals");
        ASSERT_METHODS.add("system.assertnotequals");
        ASSERT_METHODS.add("assert.areequal");
        ASSERT_METHODS.add("assert.arenotequal");
        ASSERT_METHODS.add("assert.fail");
        ASSERT_METHODS.add("assert.isfalse");
        ASSERT_METHODS.add("assert.isinstanceoftype");
        ASSERT_METHODS.add("assert.isnotinstanceoftype");
        ASSERT_METHODS.add("assert.isnull");
        ASSERT_METHODS.add("assert.isnotnull");
        ASSERT_METHODS.add("assert.istrue");
        ASSERT_METHODS.add("system.system.assert");
        ASSERT_METHODS.add("system.system.assertequals");
        ASSERT_METHODS.add("system.system.assertnotequals");
        ASSERT_METHODS.add("system.assert.areequal");
        ASSERT_METHODS.add("system.assert.arenotequal");
        ASSERT_METHODS.add("system.assert.fail");
        ASSERT_METHODS.add("system.assert.isfalse");
        ASSERT_METHODS.add("system.assert.isinstanceoftype");
        ASSERT_METHODS.add("system.assert.isnotinstanceoftype");
        ASSERT_METHODS.add("system.assert.isnull");
        ASSERT_METHODS.add("system.assert.isnotnull");
        ASSERT_METHODS.add("system.assert.istrue");
        ADDITIONAL_ASSERT_METHOD_PATTERN_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"additionalAssertMethodPattern").desc("A regular expression for one or more custom test assertion method patterns.")).defaultValue((Object)"")).build();
    }
}

