/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.codestyle;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.sourceforge.pmd.lang.apex.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTFieldDeclarationStatements;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTProperty;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class FieldDeclarationsShouldBeAtStartRule
extends AbstractApexRule {
    private static final Comparator<ApexNode<?>> NODE_BY_SOURCE_LOCATION_COMPARATOR = Comparator.comparingInt(Node::getBeginLine).thenComparing(Node::getBeginColumn);

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTUserClass.class, (Class[])new Class[0]);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        List fields = node.children(ASTFieldDeclarationStatements.class).children(ASTFieldDeclaration.class).toList();
        ArrayList nonFieldDeclarations = new ArrayList();
        nonFieldDeclarations.addAll(this.getMethodNodes(node));
        nonFieldDeclarations.addAll(node.children(ASTUserClass.class).toList());
        nonFieldDeclarations.addAll(node.children(ASTProperty.class).toList());
        nonFieldDeclarations.addAll(node.children(ASTBlockStatement.class).toList());
        Optional<ApexNode<?>> firstNonFieldDeclaration = nonFieldDeclarations.stream().filter(ApexNode::hasRealLoc).min(NODE_BY_SOURCE_LOCATION_COMPARATOR);
        if (!firstNonFieldDeclaration.isPresent()) {
            return data;
        }
        for (ASTFieldDeclaration field : fields) {
            if (NODE_BY_SOURCE_LOCATION_COMPARATOR.compare(field, firstNonFieldDeclaration.get()) <= 0) continue;
            this.asCtx(data).addViolation((Node)field, new Object[]{field.getName()});
        }
        return data;
    }

    private List<? extends ApexNode<?>> getMethodNodes(ASTUserClass node) {
        return node.descendants(ASTMethod.class).map(m -> m).toList();
    }
}

