/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.design;

import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTParameter;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClassOrInterface;
import net.sourceforge.pmd.lang.apex.ast.ASTUserEnum;
import net.sourceforge.pmd.lang.apex.ast.ASTUserInterface;
import net.sourceforge.pmd.lang.apex.ast.ASTUserTrigger;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.metrics.ApexMetrics;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.metrics.MetricsUtil;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class NcssCountRule
extends AbstractApexRule {
    private static final PropertyDescriptor<Integer> METHOD_REPORT_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"methodReportLevel").desc("NCSS reporting threshold for methods")).require(NumericConstraints.positive())).defaultValue((Object)40)).build();
    private static final PropertyDescriptor<Integer> CLASS_REPORT_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"classReportLevel").desc("NCSS reporting threshold for classes")).require(NumericConstraints.positive())).defaultValue((Object)500)).build();

    public NcssCountRule() {
        this.definePropertyDescriptor(METHOD_REPORT_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor(CLASS_REPORT_LEVEL_DESCRIPTOR);
    }

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTUserClassOrInterface.class, (Class[])new Class[]{ASTMethod.class});
    }

    @Override
    public Object visitApexNode(ApexNode<?> node, Object data) {
        int methodReportLevel = (Integer)this.getProperty(METHOD_REPORT_LEVEL_DESCRIPTOR);
        int classReportLevel = (Integer)this.getProperty(CLASS_REPORT_LEVEL_DESCRIPTOR);
        if (node instanceof ASTUserClassOrInterface) {
            this.visitTypeDecl((ASTUserClassOrInterface)node, classReportLevel, (RuleContext)data);
        } else if (node instanceof ASTMethod) {
            this.visitMethod((ASTMethod)node, methodReportLevel, (RuleContext)data);
        } else {
            throw AssertionUtil.shouldNotReachHere((String)("node is not handled: " + node));
        }
        return data;
    }

    private void visitTypeDecl(ASTUserClassOrInterface<?> node, int level, RuleContext ruleContext) {
        if (ApexMetrics.NCSS.supports(node)) {
            int classSize = (Integer)MetricsUtil.computeMetric(ApexMetrics.NCSS, node);
            int classHighest = (int)MetricsUtil.computeStatistics(ApexMetrics.NCSS, node.getMethods()).getMax();
            if (classSize >= level) {
                ruleContext.addViolation(node, new Object[]{NcssCountRule.getPrintableNodeKind(node), node.getSimpleName(), classSize, level + ", highest: " + classHighest});
            }
        }
    }

    private static String getPrintableNodeKind(ASTUserClassOrInterface<?> node) {
        if (node instanceof ASTUserClass) {
            return "class";
        }
        if (node instanceof ASTUserInterface) {
            return "interface";
        }
        if (node instanceof ASTUserEnum) {
            return "enum";
        }
        if (node instanceof ASTUserTrigger) {
            return "trigger";
        }
        throw new IllegalStateException("unknown type: " + node.getClass().getName());
    }

    private void visitMethod(ASTMethod node, int level, RuleContext ruleContext) {
        int methodSize;
        if (ApexMetrics.NCSS.supports((Node)node) && (methodSize = ((Integer)MetricsUtil.computeMetric(ApexMetrics.NCSS, (Node)node)).intValue()) >= level) {
            ruleContext.addViolation((Node)node, new Object[]{node.isConstructor() ? "constructor" : "method", this.displaySignature(node), methodSize, level});
        }
    }

    private String displaySignature(ASTMethod node) {
        StringBuilder sb = new StringBuilder(node.getCanonicalName()).append('(');
        if (node.getArity() > 0) {
            sb.append(node.children(ASTParameter.class).toStream().map(ASTParameter::getType).collect(Collectors.joining(",")));
        }
        sb.append(')');
        return sb.toString();
    }
}

