/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.errorprone;

import java.util.Locale;
import java.util.Set;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class AvoidStatefulDatabaseResultRule
extends AbstractApexRule {
    private static final Set<String> DATABASE_RESULT_TYPES = CollectionUtil.immutableSetOf((Object)"database.leadconvertresult", (Object[])new String[]{"database.deleteresult", "database.emptyrecyclebinresult", "database.mergeresult", "database.saveresult", "database.undeleteresult", "database.upsertresult"});

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTUserClass.class, (Class[])new Class[0]);
    }

    @Override
    public Object visit(ASTUserClass theClass, Object data) {
        if (!this.implementsDatabaseStateful(theClass)) {
            return data;
        }
        for (ASTField theField : theClass.descendants(ASTField.class)) {
            if (!this.isNonTransientInstanceDatabaseResultField(theField)) continue;
            this.asCtx(data).addViolation((Node)theField);
        }
        return data;
    }

    private boolean implementsDatabaseStateful(ASTUserClass theClass) {
        for (String interfaceName : theClass.getInterfaceNames()) {
            if (!"database.stateful".equalsIgnoreCase(interfaceName)) continue;
            return true;
        }
        return false;
    }

    private boolean isNonTransientInstanceDatabaseResultField(ASTField theField) {
        return !theField.getModifiers().isStatic() && !theField.getModifiers().isTransient() && this.isDatabaseResultOrCollection(theField.getType());
    }

    private boolean isDatabaseResultOrCollection(String type) {
        for (String databaseResultType : DATABASE_RESULT_TYPES) {
            if (!type.toLowerCase(Locale.ROOT).contains(databaseResultType)) continue;
            return true;
        }
        return false;
    }
}

