/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.visualforce;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DataType {
    AutoNumber(false, new String[0]),
    Checkbox(false, "Boolean"),
    Currency(false, "Currency"),
    Date(false, "Date"),
    DateTime(false, "Datetime"),
    Email(false, new String[0]),
    EncryptedText(true, new String[0]),
    ExternalLookup(true, new String[0]),
    File(false, new String[0]),
    Hierarchy(false, new String[0]),
    Html(false, new String[0]),
    IndirectLookup(false, new String[0]),
    Location(false, new String[0]),
    LongTextArea(true, new String[0]),
    Lookup(false, "Id"),
    MasterDetail(false, new String[0]),
    MetadataRelationship(false, new String[0]),
    MultiselectPicklist(true, new String[0]),
    Note(true, new String[0]),
    Number(false, "Decimal", "Double", "Integer", "Long"),
    Percent(false, new String[0]),
    Phone(false, new String[0]),
    Picklist(true, new String[0]),
    Summary(false, new String[0]),
    Text(true, "String"),
    TextArea(true, new String[0]),
    Time(false, "Time"),
    Url(false, new String[0]),
    Unknown(true, new String[0]);

    private static final Logger LOG;
    public final boolean requiresEscaping;
    private final Set<String> basicTypeNames;
    private static final Map<String, DataType> CASE_NORMALIZED_MAP;
    private static final Map<String, DataType> BASIC_TYPE_MAP;

    public static DataType fromString(String value) {
        DataType dataType = CASE_NORMALIZED_MAP.get((value = value != null ? value : "").toLowerCase(Locale.ROOT));
        if (dataType == null) {
            dataType = Unknown;
            LOG.debug("Unable to determine DataType of {}", (Object)value);
        }
        return dataType;
    }

    public static DataType fromTypeName(String value) {
        DataType dataType = BASIC_TYPE_MAP.get((value = value != null ? value : "").toLowerCase(Locale.ROOT));
        if (dataType == null) {
            dataType = Unknown;
            LOG.debug("Unable to determine DataType of {}", (Object)value);
        }
        return dataType;
    }

    private DataType(boolean requiresEscaping, String ... basicTypeNames) {
        this.requiresEscaping = requiresEscaping;
        this.basicTypeNames = new HashSet<String>(Arrays.asList(basicTypeNames));
    }

    static {
        LOG = LoggerFactory.getLogger(DataType.class);
        CASE_NORMALIZED_MAP = new HashMap<String, DataType>();
        BASIC_TYPE_MAP = new HashMap<String, DataType>();
        for (DataType dataType : DataType.values()) {
            CASE_NORMALIZED_MAP.put(dataType.name().toLowerCase(Locale.ROOT), dataType);
            for (String typeName : dataType.basicTypeNames) {
                BASIC_TYPE_MAP.put(typeName.toLowerCase(Locale.ROOT), dataType);
            }
        }
    }
}

