/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.visualforce.ast;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.visualforce.DataType;
import net.sourceforge.pmd.lang.visualforce.VfLanguageProperties;
import net.sourceforge.pmd.lang.visualforce.ast.ASTAttribute;
import net.sourceforge.pmd.lang.visualforce.ast.ASTAttributeValue;
import net.sourceforge.pmd.lang.visualforce.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.visualforce.ast.ASTElExpression;
import net.sourceforge.pmd.lang.visualforce.ast.ASTElement;
import net.sourceforge.pmd.lang.visualforce.ast.ASTExpression;
import net.sourceforge.pmd.lang.visualforce.ast.ASTText;
import net.sourceforge.pmd.lang.visualforce.ast.ApexClassPropertyTypes;
import net.sourceforge.pmd.lang.visualforce.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.visualforce.ast.ObjectFieldTypes;
import net.sourceforge.pmd.lang.visualforce.ast.VfTypedNode;
import net.sourceforge.pmd.lang.visualforce.ast.VfVisitorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VfExpressionTypeVisitor
extends VfVisitorBase<Void, Void> {
    private static final Logger LOG = LoggerFactory.getLogger(VfExpressionTypeVisitor.class);
    private static final String APEX_PAGE = "apex:page";
    private static final String CONTROLLER_ATTRIBUTE = "controller";
    private static final String STANDARD_CONTROLLER_ATTRIBUTE = "standardcontroller";
    private static final String EXTENSIONS_ATTRIBUTE = "extensions";
    private final ApexClassPropertyTypes apexClassPropertyTypes;
    private final ObjectFieldTypes objectFieldTypes;
    private final FileId fileId;
    private String standardControllerName;
    private final List<String> apexClassNames;
    private final List<String> apexDirectories;
    private final List<String> objectsDirectories;

    VfExpressionTypeVisitor(Parser.ParserTask task, VfLanguageProperties vfProperties) {
        this.fileId = task.getFileId();
        this.apexDirectories = (List)vfProperties.getProperty(VfLanguageProperties.APEX_DIRECTORIES_DESCRIPTOR);
        this.objectsDirectories = (List)vfProperties.getProperty(VfLanguageProperties.OBJECTS_DIRECTORIES_DESCRIPTOR);
        this.apexClassNames = new ArrayList<String>();
        this.apexClassPropertyTypes = new ApexClassPropertyTypes(task.getLpRegistry());
        this.objectFieldTypes = new ObjectFieldTypes();
    }

    @Override
    public Void visit(ASTCompilationUnit node, Void data) {
        if (this.apexDirectories.isEmpty() && this.objectsDirectories.isEmpty()) {
            return data;
        }
        return (Void)super.visit(node, (Object)data);
    }

    @Override
    public Void visit(ASTElement node, Void data) {
        if (APEX_PAGE.equalsIgnoreCase(node.getName())) {
            for (ASTAttribute attr : node.children(ASTAttribute.class)) {
                String lowerAttr = attr.getName().toLowerCase(Locale.ROOT);
                if (CONTROLLER_ATTRIBUTE.equals(lowerAttr)) {
                    this.apexClassNames.add(0, VfExpressionTypeVisitor.getAttrValue(attr));
                    break;
                }
                if (STANDARD_CONTROLLER_ATTRIBUTE.equals(lowerAttr)) {
                    this.standardControllerName = VfExpressionTypeVisitor.getAttrValue(attr).toLowerCase(Locale.ROOT);
                    continue;
                }
                if (!EXTENSIONS_ATTRIBUTE.equalsIgnoreCase(lowerAttr)) continue;
                for (String extension : VfExpressionTypeVisitor.getAttrValue(attr).split(",")) {
                    this.apexClassNames.add(extension.trim());
                }
            }
        }
        return (Void)super.visit(node, (Object)data);
    }

    private static String getAttrValue(ASTAttribute attr) {
        return ((ASTText)((ASTAttributeValue)attr.firstChild(ASTAttributeValue.class)).firstChild(ASTText.class)).getImage();
    }

    @Override
    public Void visit(ASTElExpression node, Void data) {
        for (Map.Entry<VfTypedNode, String> entry : this.getDataNodeNames(node).entrySet()) {
            String apexClassName;
            String fullName;
            String name = entry.getValue();
            DataType type = null;
            String[] parts = name.split("\\.");
            Iterator<String> iterator = this.apexClassNames.iterator();
            while (iterator.hasNext() && (type = this.apexClassPropertyTypes.getDataType(fullName = (apexClassName = iterator.next()) + "." + name, this.fileId, this.apexDirectories)) == null) {
            }
            if (type == null && parts.length >= 2 && this.standardControllerName != null && this.standardControllerName.equalsIgnoreCase(parts[0])) {
                type = this.objectFieldTypes.getDataType(name, this.fileId, this.objectsDirectories);
            }
            if (type != null) {
                InternalApiBridge.setDataType(entry.getKey(), type);
                continue;
            }
            LOG.debug("Unable to determine type for: {}", (Object)name);
        }
        return (Void)super.visit(node, (Object)data);
    }

    private Map<VfTypedNode, String> getDataNodeNames(ASTElExpression node) {
        IdentityHashMap<VfTypedNode, String> dataNodeToName = new IdentityHashMap<VfTypedNode, String>();
        for (ASTExpression expression : node.children(ASTExpression.class)) {
            try {
                dataNodeToName.putAll(expression.getDataNodes());
            }
            catch (ASTExpression.DataNodeStateException dataNodeStateException) {}
        }
        return dataNodeToName;
    }
}

