/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.visualforce.rule.security;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.visualforce.ast.ASTAttribute;
import net.sourceforge.pmd.lang.visualforce.ast.ASTContent;
import net.sourceforge.pmd.lang.visualforce.ast.ASTElExpression;
import net.sourceforge.pmd.lang.visualforce.ast.ASTElement;
import net.sourceforge.pmd.lang.visualforce.ast.ASTExpression;
import net.sourceforge.pmd.lang.visualforce.ast.ASTHtmlScript;
import net.sourceforge.pmd.lang.visualforce.ast.ASTLiteral;
import net.sourceforge.pmd.lang.visualforce.ast.ASTText;
import net.sourceforge.pmd.lang.visualforce.rule.AbstractVfRule;
import net.sourceforge.pmd.lang.visualforce.rule.security.internal.ElEscapeDetector;

public class VfUnescapeElRule
extends AbstractVfRule {
    private static final String A_CONST = "a";
    private static final String APEXIFRAME_CONST = "apex:iframe";
    private static final String IFRAME_CONST = "iframe";
    private static final String HREF = "href";
    private static final String SRC = "src";
    private static final String APEX_PARAM = "apex:param";
    private static final String VALUE = "value";
    private static final String ITEM_VALUE = "itemvalue";
    private static final String ESCAPE = "escape";
    private static final String ITEM_ESCAPED = "itemescaped";
    private static final String APEX_OUTPUT_TEXT = "apex:outputtext";
    private static final String APEX_PAGE_MESSAGE = "apex:pagemessage";
    private static final String APEX_PAGE_MESSAGES = "apex:pagemessages";
    private static final String APEX_SELECT_OPTION = "apex:selectoption";
    private static final String FALSE = "false";
    private static final Pattern ON_EVENT = Pattern.compile("^on(\\w)+$");
    private static final Pattern PLACEHOLDERS = Pattern.compile("\\{(\\w|,|\\.|'|:|\\s)*\\}");
    private static final Set<ElEscapeDetector.Escaping> JSENCODE_JSINHTMLENCODE = EnumSet.of(ElEscapeDetector.Escaping.JSENCODE, ElEscapeDetector.Escaping.JSINHTMLENCODE);
    private static final Set<ElEscapeDetector.Escaping> ANY_ENCODE = EnumSet.of(ElEscapeDetector.Escaping.ANY);

    @Override
    public Object visit(ASTHtmlScript node, Object data) {
        this.checkIfCorrectlyEscaped(node, data);
        return super.visit(node, data);
    }

    private void checkIfCorrectlyEscaped(ASTHtmlScript node, Object data) {
        for (int i = 0; i < node.getNumChildren(); ++i) {
            Node n = node.getChild(i);
            if (!(n instanceof ASTElExpression)) continue;
            this.processElInScriptContext((ASTElExpression)n, data);
        }
    }

    private void processElInScriptContext(ASTElExpression elExpression, Object data) {
        if (!this.properlyEscaped(elExpression)) {
            this.asCtx(data).addViolation((Node)elExpression);
        }
    }

    private boolean properlyEscaped(ASTElExpression el) {
        ASTExpression expression = (ASTExpression)el.firstChild(ASTExpression.class);
        return expression == null || ElEscapeDetector.expressionRecursivelyValid(expression, JSENCODE_JSINHTMLENCODE);
    }

    @Override
    public Object visit(ASTElement node, Object data) {
        if (this.doesTagSupportEscaping(node)) {
            this.checkApexTagsThatSupportEscaping(node, data);
        } else {
            this.checkLimitedFlags(node, data);
            this.checkAllOnEventTags(node, data);
        }
        return super.visit(node, data);
    }

    private void checkLimitedFlags(ASTElement node, Object data) {
        switch (node.getName().toLowerCase(Locale.ROOT)) {
            case "iframe": 
            case "apex:iframe": 
            case "a": {
                break;
            }
            default: {
                return;
            }
        }
        List attributes = node.children(ASTAttribute.class).toList();
        boolean isEL = false;
        HashSet<ASTElExpression> toReport = new HashSet<ASTElExpression>();
        for (ASTAttribute attr : attributes) {
            ASTElExpression el;
            String lowerCaseImage;
            String name = attr.getName().toLowerCase(Locale.ROOT);
            if (!HREF.equalsIgnoreCase(name) && !SRC.equalsIgnoreCase(name)) continue;
            boolean startingWithSlashText = false;
            ASTText attrText = (ASTText)attr.descendants(ASTText.class).first();
            if (attrText != null && 0 == attrText.getIndexInParent() && ((lowerCaseImage = attrText.getImage().toLowerCase(Locale.ROOT)).startsWith("/") || lowerCaseImage.startsWith("http") || lowerCaseImage.startsWith("mailto"))) {
                startingWithSlashText = true;
            }
            if (startingWithSlashText) continue;
            Iterator iterator = attr.descendants(ASTElExpression.class).iterator();
            while (iterator.hasNext() && !this.startsWithSlashLiteral(el = (ASTElExpression)iterator.next()) && !ElEscapeDetector.startsWithSafeResource(el)) {
                if (!ElEscapeDetector.doesElContainAnyUnescapedIdentifiers(el, ElEscapeDetector.Escaping.URLENCODE)) continue;
                isEL = true;
                toReport.add(el);
            }
        }
        if (isEL) {
            for (ASTElExpression expr : toReport) {
                this.asCtx(data).addViolation((Node)expr);
            }
        }
    }

    private void checkAllOnEventTags(ASTElement node, Object data) {
        boolean isEL = false;
        HashSet<ASTElExpression> toReport = new HashSet<ASTElExpression>();
        for (ASTAttribute attr : node.children(ASTAttribute.class)) {
            String name = attr.getName().toLowerCase(Locale.ROOT);
            if (!ON_EVENT.matcher(name).matches()) continue;
            for (ASTElExpression el : attr.descendants(ASTElExpression.class)) {
                if (ElEscapeDetector.startsWithSafeResource(el) || !ElEscapeDetector.doesElContainAnyUnescapedIdentifiers(el, ANY_ENCODE)) continue;
                isEL = true;
                toReport.add(el);
            }
        }
        if (isEL) {
            for (ASTElExpression expr : toReport) {
                this.asCtx(data).addViolation((Node)expr);
            }
        }
    }

    private boolean startsWithSlashLiteral(ASTElExpression elExpression) {
        String lowerCaseLiteral;
        ASTLiteral literal;
        ASTExpression expression = (ASTExpression)elExpression.firstChild(ASTExpression.class);
        return expression != null && (literal = (ASTLiteral)expression.firstChild(ASTLiteral.class)) != null && literal.getIndexInParent() == 0 && ((lowerCaseLiteral = literal.getImage().toLowerCase(Locale.ROOT)).startsWith("'/") || lowerCaseLiteral.startsWith("\"/") || lowerCaseLiteral.startsWith("'http") || lowerCaseLiteral.startsWith("\"http"));
    }

    private void checkApexTagsThatSupportEscaping(ASTElement node, Object data) {
        HashSet<ASTElExpression> toReport = new HashSet<ASTElExpression>();
        boolean isUnescaped = false;
        boolean isEL = false;
        boolean hasPlaceholders = false;
        for (ASTAttribute attr : node.children(ASTAttribute.class)) {
            String name;
            switch (name = attr.getName().toLowerCase(Locale.ROOT)) {
                case "escape": 
                case "itemescaped": {
                    ASTText text = (ASTText)attr.descendants(ASTText.class).first();
                    if (text == null || !FALSE.equalsIgnoreCase(text.getImage())) break;
                    isUnescaped = true;
                    break;
                }
                case "value": 
                case "itemvalue": {
                    for (ASTElExpression el : attr.descendants(ASTElExpression.class)) {
                        if (ElEscapeDetector.startsWithSafeResource(el) || !ElEscapeDetector.doesElContainAnyUnescapedIdentifiers(el, ElEscapeDetector.Escaping.HTMLENCODE)) continue;
                        isEL = true;
                        toReport.add(el);
                    }
                    ASTText textValue = (ASTText)attr.descendants(ASTText.class).first();
                    if (textValue == null || !PLACEHOLDERS.matcher(textValue.getImage()).matches()) break;
                    hasPlaceholders = true;
                    break;
                }
            }
        }
        if (hasPlaceholders && isUnescaped) {
            for (ASTElExpression expr : this.hasELInInnerElements(node)) {
                this.asCtx(data).addViolation((Node)expr);
            }
        }
        if (isEL && isUnescaped) {
            for (ASTElExpression expr : toReport) {
                this.asCtx(data).addViolation((Node)expr);
            }
        }
    }

    private boolean doesTagSupportEscaping(ASTElement node) {
        if (node.getName() == null) {
            return false;
        }
        switch (node.getName().toLowerCase(Locale.ROOT)) {
            case "apex:outputtext": 
            case "apex:pagemessage": 
            case "apex:pagemessages": 
            case "apex:selectoption": {
                return true;
            }
        }
        return false;
    }

    private Set<ASTElExpression> hasELInInnerElements(ASTElement node) {
        HashSet<ASTElExpression> toReturn = new HashSet<ASTElExpression>();
        ASTContent content = (ASTContent)node.firstChild(ASTContent.class);
        if (content != null) {
            for (ASTElement element : content.children(ASTElement.class)) {
                if (!APEX_PARAM.equalsIgnoreCase(element.getName())) continue;
                for (ASTAttribute attrib : element.children(ASTAttribute.class)) {
                    for (ASTElExpression el : attrib.descendants(ASTElExpression.class)) {
                        if (ElEscapeDetector.startsWithSafeResource(el) || !ElEscapeDetector.doesElContainAnyUnescapedIdentifiers(el, ElEscapeDetector.Escaping.HTMLENCODE)) continue;
                        toReturn.add(el);
                    }
                }
            }
        }
        return toReturn;
    }
}

