/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.velocity.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.velocity.ast.ASTBlock;
import net.sourceforge.pmd.lang.velocity.ast.ASTElseIfStatement;
import net.sourceforge.pmd.lang.velocity.ast.ASTElseStatement;
import net.sourceforge.pmd.lang.velocity.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.velocity.ast.ASTText;
import net.sourceforge.pmd.lang.velocity.ast.VtlNode;
import net.sourceforge.pmd.lang.velocity.rule.AbstractVtlRule;
import org.apache.commons.lang3.StringUtils;

public class CollapsibleIfStatementsRule
extends AbstractVtlRule {
    @Override
    public Object visit(ASTIfStatement node, Object data) {
        this.handleIfElseIf(node, data);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTElseIfStatement node, Object data) {
        if (((VtlNode)node.getParent()).children(ASTElseIfStatement.class).count() == 1) {
            this.handleIfElseIf(node, data);
        }
        return super.visit(node, data);
    }

    private void handleIfElseIf(VtlNode node, Object data) {
        if (node.firstChild(ASTElseStatement.class) == null && node.firstChild(ASTElseIfStatement.class) == null) {
            ASTBlock ifBlock = (ASTBlock)node.firstChild(ASTBlock.class);
            boolean violationFound = false;
            int ifCounter = 0;
            for (int i = 0; i < ifBlock.getNumChildren(); ++i) {
                Node blockChild = ifBlock.getChild(i);
                if (blockChild instanceof ASTText) {
                    if (!StringUtils.isNotBlank((CharSequence)((ASTText)blockChild).getFirstToken().getImage())) continue;
                    violationFound = false;
                    break;
                }
                if (blockChild instanceof ASTIfStatement) {
                    boolean bl = violationFound = !this.hasElseOrElseIf(blockChild);
                    if (!violationFound) break;
                    ++ifCounter;
                    continue;
                }
                if (blockChild instanceof ASTElseIfStatement) {
                    boolean bl = violationFound = !this.hasElseOrElseIf(blockChild);
                    if (!violationFound) break;
                    ++ifCounter;
                    continue;
                }
                violationFound = false;
                break;
            }
            if (violationFound && ifCounter == 1) {
                this.asCtx(data).addViolation((Node)node);
            }
        }
    }

    private boolean hasElseOrElseIf(Node parentIfNode) {
        return parentIfNode.firstChild(ASTElseStatement.class) != null || parentIfNode.firstChild(ASTElseIfStatement.class) != null;
    }
}

