/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.FileContentsHolder;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public class SuppressionCommentFilter
extends AutomaticBean
implements Filter {
    private static final String DEFAULT_OFF_FORMAT = "CHECKSTYLE\\:OFF";
    private static final String DEFAULT_ON_FORMAT = "CHECKSTYLE\\:ON";
    private static final String DEFAULT_CHECK_FORMAT = ".*";
    private boolean checkC = true;
    private boolean checkCPP = true;
    private Pattern offRegexp;
    private Pattern onRegexp;
    private String checkFormat;
    private String messageFormat;
    private final List<Tag> tags = Lists.newArrayList();
    private WeakReference<FileContents> fileContentsReference = new WeakReference<Object>(null);

    public SuppressionCommentFilter() {
        this.setOnCommentFormat(DEFAULT_ON_FORMAT);
        this.setOffCommentFormat(DEFAULT_OFF_FORMAT);
        this.checkFormat = DEFAULT_CHECK_FORMAT;
    }

    public final void setOffCommentFormat(String format) {
        this.offRegexp = CommonUtils.createPattern(format);
    }

    public final void setOnCommentFormat(String format) {
        this.onRegexp = CommonUtils.createPattern(format);
    }

    public FileContents getFileContents() {
        return (FileContents)this.fileContentsReference.get();
    }

    public void setFileContents(FileContents fileContents) {
        this.fileContentsReference = new WeakReference<FileContents>(fileContents);
    }

    public final void setCheckFormat(String format) {
        this.checkFormat = format;
    }

    public void setMessageFormat(String format) {
        this.messageFormat = format;
    }

    public void setCheckCPP(boolean checkCPP) {
        this.checkCPP = checkCPP;
    }

    public void setCheckC(boolean checkC) {
        this.checkC = checkC;
    }

    @Override
    public boolean accept(AuditEvent event) {
        FileContents currentContents;
        boolean accepted = true;
        if (event.getLocalizedMessage() != null && (currentContents = FileContentsHolder.getContents()) != null) {
            Tag matchTag;
            if (this.getFileContents() != currentContents) {
                this.setFileContents(currentContents);
                this.tagSuppressions();
            }
            accepted = (matchTag = this.findNearestMatch(event)) == null || matchTag.isOn();
        }
        return accepted;
    }

    private Tag findNearestMatch(AuditEvent event) {
        Tag result = null;
        for (Tag tag : this.tags) {
            if (tag.getLine() > event.getLine() || tag.getLine() == event.getLine() && tag.getColumn() > event.getColumn()) break;
            if (!tag.isMatch(event)) continue;
            result = tag;
        }
        return result;
    }

    private void tagSuppressions() {
        this.tags.clear();
        FileContents contents = this.getFileContents();
        if (this.checkCPP) {
            this.tagSuppressions(contents.getCppComments().values());
        }
        if (this.checkC) {
            Collection cComments = contents.getCComments().values();
            for (List element : cComments) {
                this.tagSuppressions(element);
            }
        }
        Collections.sort(this.tags);
    }

    private void tagSuppressions(Collection<TextBlock> comments) {
        for (TextBlock comment : comments) {
            int startLineNo = comment.getStartLineNo();
            String[] text = comment.getText();
            this.tagCommentLine(text[0], startLineNo, comment.getStartColNo());
            for (int i = 1; i < text.length; ++i) {
                this.tagCommentLine(text[i], startLineNo + i, 0);
            }
        }
    }

    private void tagCommentLine(String text, int line, int column) {
        Matcher offMatcher = this.offRegexp.matcher(text);
        if (offMatcher.find()) {
            this.addTag(offMatcher.group(0), line, column, false);
        } else {
            Matcher onMatcher = this.onRegexp.matcher(text);
            if (onMatcher.find()) {
                this.addTag(onMatcher.group(0), line, column, true);
            }
        }
    }

    private void addTag(String text, int line, int column, boolean on) {
        Tag tag = new Tag(line, column, text, on, this);
        this.tags.add(tag);
    }

    public static class Tag
    implements Comparable<Tag> {
        private final String text;
        private final int line;
        private final int column;
        private final boolean on;
        private final Pattern tagCheckRegexp;
        private final Pattern tagMessageRegexp;

        public Tag(int line, int column, String text, boolean on, SuppressionCommentFilter filter) {
            this.line = line;
            this.column = column;
            this.text = text;
            this.on = on;
            String format = "";
            try {
                if (on) {
                    format = Tag.expandFromComment(text, filter.checkFormat, filter.onRegexp);
                    this.tagCheckRegexp = Pattern.compile(format);
                    if (filter.messageFormat != null) {
                        format = Tag.expandFromComment(text, filter.messageFormat, filter.onRegexp);
                        this.tagMessageRegexp = Pattern.compile(format);
                    } else {
                        this.tagMessageRegexp = null;
                    }
                } else {
                    format = Tag.expandFromComment(text, filter.checkFormat, filter.offRegexp);
                    this.tagCheckRegexp = Pattern.compile(format);
                    if (filter.messageFormat != null) {
                        format = Tag.expandFromComment(text, filter.messageFormat, filter.offRegexp);
                        this.tagMessageRegexp = Pattern.compile(format);
                    } else {
                        this.tagMessageRegexp = null;
                    }
                }
            }
            catch (PatternSyntaxException e) {
                throw new ConversionException("unable to parse expanded comment " + format, e);
            }
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean isOn() {
            return this.on;
        }

        @Override
        public int compareTo(Tag object) {
            if (this.line == object.line) {
                return Integer.compare(this.column, object.column);
            }
            return Integer.compare(this.line, object.line);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tag tag = (Tag)o;
            return Objects.equals(this.line, tag.line) && Objects.equals(this.column, tag.column) && Objects.equals(this.on, tag.on) && Objects.equals(this.text, tag.text);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.line, this.column, this.on);
        }

        public boolean isMatch(AuditEvent event) {
            boolean match = false;
            Matcher tagMatcher = this.tagCheckRegexp.matcher(event.getSourceName());
            if (tagMatcher.find()) {
                if (this.tagMessageRegexp != null) {
                    Matcher messageMatcher = this.tagMessageRegexp.matcher(event.getMessage());
                    match = messageMatcher.find();
                } else {
                    match = true;
                }
            }
            return match;
        }

        private static String expandFromComment(String comment, String stringToExpand, Pattern regexp) {
            Matcher matcher = regexp.matcher(comment);
            if (!matcher.find()) {
                return stringToExpand;
            }
            String result = stringToExpand;
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                result = result.replaceAll("\\$" + i, matcher.group(i));
            }
            return result;
        }

        public final String toString() {
            return "Tag[line=" + this.line + "; col=" + this.column + "; on=" + this.on + "; text='" + this.text + "']";
        }
    }
}

