/*
 * Decompiled with CFR 0.152.
 */
package com.nawforce.pkgforce.documents;

import com.nawforce.pkgforce.diagnostics.Diagnostic;
import com.nawforce.pkgforce.diagnostics.ERROR_CATEGORY$;
import com.nawforce.pkgforce.diagnostics.Issue;
import com.nawforce.pkgforce.diagnostics.Issue$;
import com.nawforce.pkgforce.diagnostics.IssueLogger;
import com.nawforce.pkgforce.documents.ApexMetaNature$;
import com.nawforce.pkgforce.documents.ApexNature$;
import com.nawforce.pkgforce.documents.ComponentNature$;
import com.nawforce.pkgforce.documents.FieldNature$;
import com.nawforce.pkgforce.documents.FieldSetNature$;
import com.nawforce.pkgforce.documents.FlowNature$;
import com.nawforce.pkgforce.documents.LabelNature$;
import com.nawforce.pkgforce.documents.MetadataDocument;
import com.nawforce.pkgforce.documents.MetadataDocument$;
import com.nawforce.pkgforce.documents.MetadataNature;
import com.nawforce.pkgforce.documents.PageNature$;
import com.nawforce.pkgforce.documents.SObjectDocument;
import com.nawforce.pkgforce.documents.SObjectNature$;
import com.nawforce.pkgforce.documents.SharingReasonNature$;
import com.nawforce.pkgforce.documents.TriggerMetaNature$;
import com.nawforce.pkgforce.documents.TriggerNature$;
import com.nawforce.pkgforce.names.EncodedName;
import com.nawforce.pkgforce.names.EncodedName$;
import com.nawforce.pkgforce.names.Name;
import com.nawforce.pkgforce.names.TypeName;
import com.nawforce.pkgforce.path.Location$;
import com.nawforce.pkgforce.path.PathLike;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001B\t\u0013\u0001mA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!A1\u0007\u0001B\u0001B\u0003%A\u0007C\u00038\u0001\u0011\u0005\u0001\bC\u0003?\u0001\u0011\u0005q\bC\u0003\\\u0001\u0011%A\fC\u0003_\u0001\u0011%q\fC\u0003b\u0001\u0011%!\rC\u0003n\u0001\u0011%a\u000eC\u0003t\u0001\u0011%A\u000fC\u0003w\u0001\u0011%q\u000fC\u0003z\u0001\u0011%!\u0010C\u0003}\u0001\u0011%Q\u0010\u0003\u0004\u0000\u0001\u0011%\u0011\u0011\u0001\u0005\b\u0003\u000b\u0001A\u0011BA\u0004\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001f\u0011\u0011#T3uC\u0012\fG/\u0019,bY&$\u0017\r^8s\u0015\t\u0019B#A\u0005e_\u000e,X.\u001a8ug*\u0011QCF\u0001\ta.<gm\u001c:dK*\u0011q\u0003G\u0001\t]\u0006<hm\u001c:dK*\t\u0011$A\u0002d_6\u001c\u0001a\u0005\u0002\u00019A\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\fa\u0001\\8hO\u0016\u0014\bC\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u0015\u0003-!\u0017.Y4o_N$\u0018nY:\n\u0005!*#aC%tgV,Gj\\4hKJ\f\u0011B\\1nKN\u0004\u0018mY3\u0011\u0007uYS&\u0003\u0002-=\t1q\n\u001d;j_:\u0004\"AL\u0019\u000e\u0003=R!\u0001\r\u000b\u0002\u000b9\fW.Z:\n\u0005Iz#\u0001\u0002(b[\u0016\f\u0001\"[:Hk2\u0004X\r\u001a\t\u0003;UJ!A\u000e\u0010\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"B!O\u001e={A\u0011!\bA\u0007\u0002%!)!\u0005\u0002a\u0001G!)\u0011\u0006\u0002a\u0001U!)1\u0007\u0002a\u0001i\u0005Aa/\u00197jI\u0006$X\rF\u0002A\u0007\"\u0003\"!H!\n\u0005\ts\"\u0001B+oSRDQ\u0001R\u0003A\u0002\u0015\u000baA\\1ukJ,\u0007C\u0001\u001eG\u0013\t9%C\u0001\bNKR\fG-\u0019;b\u001d\u0006$XO]3\t\u000bM)\u0001\u0019A%\u0011\u0007)\u0013VK\u0004\u0002L!:\u0011AjT\u0007\u0002\u001b*\u0011aJG\u0001\u0007yI|w\u000e\u001e \n\u0003}I!!\u0015\u0010\u0002\u000fA\f7m[1hK&\u00111\u000b\u0016\u0002\u0005\u0019&\u001cHO\u0003\u0002R=A\u0011a+W\u0007\u0002/*\u0011\u0001\fF\u0001\u0005a\u0006$\b.\u0003\u0002[/\nA\u0001+\u0019;i\u0019&\\W-\u0001\u0007wC2LG-\u0019;f\u0003B,\u0007\u0010\u0006\u0002A;\")1C\u0002a\u0001\u0013\u0006ya/\u00197jI\u0006$X\r\u0016:jO\u001e,'\u000f\u0006\u0002AA\")1c\u0002a\u0001\u0013\u0006ar-\u001a;TS:<G.Z\"p]R\u0014x\u000e\u001c7j]\u001e$unY;nK:$H\u0003B2hS.\u00042!H\u0016e!\tQT-\u0003\u0002g%\t\u0001R*\u001a;bI\u0006$\u0018\rR8dk6,g\u000e\u001e\u0005\u0006Q\"\u0001\r!R\u0001\u0012G>tGO]8mY&twMT1ukJ,\u0007\"\u00026\t\u0001\u0004)\u0015AC7fi\u0006t\u0015\r^;sK\")1\u0003\u0003a\u0001YB\u0019!J\u00153\u00021\u0005\u001c8/\u001a:u'&tw\r\\3NKR\fGi\\2v[\u0016tG\u000f\u0006\u0003A_F\u0014\b\"\u00029\n\u0001\u0004!\u0017AD2p]R\u0014x\u000e\u001c7j]\u001e$un\u0019\u0005\u0006\t&\u0001\r!\u0012\u0005\u0006'%\u0001\r\u0001\\\u0001\u0012m\u0006d\u0017\u000eZ1uK\u000e{W\u000e]8oK:$HC\u0001!v\u0011\u0015\u0019\"\u00021\u0001J\u000311\u0018\r\\5eCR,\u0007+Y4f)\t\u0001\u0005\u0010C\u0003\u0014\u0017\u0001\u0007\u0011*\u0001\u0007wC2LG-\u0019;f\r2|w\u000f\u0006\u0002Aw\")1\u0003\u0004a\u0001\u0013\u0006!\u0012m]:feR\u001c\u0016N\\4mK\u0012{7-^7f]R$\"\u0001\u0011@\t\u000bMi\u0001\u0019A%\u0002'Y\fG.\u001b3bi\u0016\u001cvJ\u00196fGRd\u0015n[3\u0015\u0007\u0001\u000b\u0019\u0001C\u0003\u0014\u001d\u0001\u0007\u0011*\u0001\tbgN,'\u000f^+oSF,XMT1nKR)\u0001)!\u0003\u0002\f!)Ai\u0004a\u0001\u000b\")1c\u0004a\u0001Y\u00069b/\u00197jI\u0006$XmQ1tKN+gn]5uSZLG/\u001f\u000b\u0006\u0001\u0006E\u00111\u0003\u0005\u0006'A\u0001\r!\u0013\u0005\b\u0003+\u0001\u0002\u0019AA\f\u0003U)\u0007\u0010]3di\u0016$G)\u001b:fGR|'/\u001f(b[\u0016\u0004B!!\u0007\u0002\"9!\u00111DA\u000f!\tae$C\u0002\u0002 y\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0012\u0003K\u0011aa\u0015;sS:<'bAA\u0010=\u0001")
public class MetadataValidator {
    private final IssueLogger logger;
    private final Option<Name> namespace;
    private final boolean isGulped;

    public void validate(MetadataNature nature, List<PathLike> documents) {
        documents.foreach((Function1 & Serializable)path -> $this.logger.pop((PathLike)path));
        MetadataNature metadataNature = nature;
        if (LabelNature$.MODULE$.equals(metadataNature)) {
            return;
        }
        if (ApexNature$.MODULE$.equals(metadataNature)) {
            this.validateApex(documents);
            return;
        }
        if (ApexMetaNature$.MODULE$.equals(metadataNature)) {
            return;
        }
        if (TriggerNature$.MODULE$.equals(metadataNature)) {
            this.validateTrigger(documents);
            return;
        }
        if (TriggerMetaNature$.MODULE$.equals(metadataNature)) {
            return;
        }
        if (ComponentNature$.MODULE$.equals(metadataNature)) {
            this.validateComponent(documents);
            return;
        }
        if (PageNature$.MODULE$.equals(metadataNature)) {
            this.validatePage(documents);
            return;
        }
        if (FlowNature$.MODULE$.equals(metadataNature)) {
            this.validateFlow(documents);
            return;
        }
        if (SObjectNature$.MODULE$.equals(metadataNature)) {
            this.validateSObjectLike(documents);
            return;
        }
        if (FieldNature$.MODULE$.equals(metadataNature)) {
            this.validateCaseSensitivity(documents, "fields");
            return;
        }
        if (FieldSetNature$.MODULE$.equals(metadataNature)) {
            this.validateCaseSensitivity(documents, "fieldSets");
            return;
        }
        if (SharingReasonNature$.MODULE$.equals(metadataNature)) {
            this.validateCaseSensitivity(documents, "sharingReasons");
            return;
        }
        throw new MatchError((Object)metadataNature);
    }

    private void validateApex(List<PathLike> documents) {
        List allDocs = documents.flatMap((Function1 & Serializable)x$1 -> MetadataDocument$.MODULE$.apply((PathLike)x$1));
        this.getSingleControllingDocument(ApexNature$.MODULE$, ApexMetaNature$.MODULE$, (List<MetadataDocument>)allDocs).foreach((Function1 & Serializable)controllingDoc -> {
            this.assertSingleMetaDocument(controllingDoc, ApexMetaNature$.MODULE$, (List<MetadataDocument>)allDocs.filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$validateApex$3(controllingDoc, x$2))));
            return BoxedUnit.UNIT;
        });
    }

    private void validateTrigger(List<PathLike> documents) {
        List allDocs = documents.flatMap((Function1 & Serializable)x$3 -> MetadataDocument$.MODULE$.apply((PathLike)x$3));
        this.getSingleControllingDocument(TriggerNature$.MODULE$, TriggerMetaNature$.MODULE$, (List<MetadataDocument>)allDocs).foreach((Function1 & Serializable)controllingDoc -> {
            this.assertSingleMetaDocument(controllingDoc, TriggerMetaNature$.MODULE$, (List<MetadataDocument>)allDocs.filterNot((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$validateTrigger$3(controllingDoc, x$4))));
            return BoxedUnit.UNIT;
        });
    }

    private Option<MetadataDocument> getSingleControllingDocument(MetadataNature controllingNature, MetadataNature metaNature, List<MetadataDocument> documents) {
        List controllingDocs = documents.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$getSingleControllingDocument$1(controllingNature, x$5)));
        if (controllingDocs.isEmpty()) {
            boolean isControllingIgnored;
            List metaDocs = documents.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$getSingleControllingDocument$2(metaNature, x$6)));
            boolean bl = isControllingIgnored = metaDocs.size() == 1 && metaDocs.headOption().exists((Function1 & Serializable)md -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$getSingleControllingDocument$3(md)));
            if (!isControllingIgnored) {
                documents.foreach((Function1 & Serializable)document -> {
                    MetadataValidator.$anonfun$getSingleControllingDocument$4(this, document);
                    return BoxedUnit.UNIT;
                });
            }
            return None$.MODULE$;
        }
        if (controllingDocs.size() > 1) {
            ((List)controllingDocs.tail()).foreach((Function1 & Serializable)document -> {
                MetadataValidator.$anonfun$getSingleControllingDocument$5(this, controllingDocs, document);
                return BoxedUnit.UNIT;
            });
            return None$.MODULE$;
        }
        return controllingDocs.headOption();
    }

    private void assertSingleMetaDocument(MetadataDocument controllingDoc, MetadataNature nature, List<MetadataDocument> documents) {
        TypeName typeName = controllingDoc.typeName(this.namespace);
        List metaDocs = documents.filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$assertSingleMetaDocument$1(nature, x$9)));
        if (!this.isGulped && metaDocs.isEmpty()) {
            this.logger.log(new Issue(controllingDoc.path(), new Diagnostic(ERROR_CATEGORY$.MODULE$, Location$.MODULE$.empty(), new StringBuilder(51).append("Type '").append(typeName).append("' is defined, but meta file is missing for '").append(controllingDoc.path()).append("'").toString()), Issue$.MODULE$.apply$default$3()));
            return;
        }
        if (metaDocs.size() > 1) {
            String otherPaths = documents.map((Function1 & Serializable)x$10 -> x$10.path()).mkString(", ");
            this.logger.log(new Issue(controllingDoc.path(), new Diagnostic(ERROR_CATEGORY$.MODULE$, Location$.MODULE$.empty(), new StringBuilder(53).append("Type '").append(typeName).append("' is defined, but multiple meta files found at ").append(otherPaths).toString()), Issue$.MODULE$.apply$default$3()));
            return;
        }
        if (metaDocs.nonEmpty()) {
            PathLike pathLike = controllingDoc.path().parent();
            PathLike pathLike2 = ((MetadataDocument)metaDocs.head()).path().parent();
            if (pathLike == null ? pathLike2 != null : !pathLike.equals(pathLike2)) {
                this.logger.log(new Issue(controllingDoc.path(), new Diagnostic(ERROR_CATEGORY$.MODULE$, Location$.MODULE$.empty(), new StringBuilder(70).append("Type '").append(typeName).append("' is defined, but its meta file is in a different directory see ").append(((MetadataDocument)metaDocs.head()).path()).toString()), Issue$.MODULE$.apply$default$3()));
                return;
            }
        }
    }

    private void validateComponent(List<PathLike> documents) {
        this.assertSingleDocument(documents);
    }

    private void validatePage(List<PathLike> documents) {
        this.assertSingleDocument(documents);
    }

    private void validateFlow(List<PathLike> documents) {
        this.assertSingleDocument(documents);
    }

    private void assertSingleDocument(List<PathLike> documents) {
        if (documents.length() > 1) {
            List allDocs = documents.flatMap((Function1 & Serializable)x$11 -> MetadataDocument$.MODULE$.apply((PathLike)x$11));
            allDocs.foreach((Function1 & Serializable)document -> {
                MetadataValidator.$anonfun$assertSingleDocument$2(this, documents, document);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void validateSObjectLike(List<PathLike> documents) {
        List allDocs = documents.flatMap((Function1 & Serializable)x$13 -> MetadataDocument$.MODULE$.apply((PathLike)x$13));
        List controllingDocs = allDocs.filter((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$validateSObjectLike$2(x$14)));
        TypeName typeName = ((MetadataDocument)allDocs.head()).controllingTypeName(this.namespace);
        boolean isSObject = BoxesRunTime.unboxToBoolean((Object)controllingDocs.headOption().map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$validateSObjectLike$3(x$15))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            EncodedName encName = EncodedName$.MODULE$.apply(typeName.name());
            return encName.ext().isEmpty() || encName.ext().exists((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$validateSObjectLike$5(x$16)));
        }));
        if (!isSObject && controllingDocs.isEmpty()) {
            this.logger.log(new Issue((PathLike)documents.minBy((Function1 & Serializable)x$17 -> x$17.toString(), (Ordering)Ordering.String$.MODULE$), new Diagnostic(ERROR_CATEGORY$.MODULE$, Location$.MODULE$.empty(), new StringBuilder(83).append("Components of type '").append(typeName).append("' are defined, but the required object-meta.xml file is missing").toString()), Issue$.MODULE$.apply$default$3()));
        } else if (controllingDocs.length() > 1) {
            controllingDocs.foreach((Function1 & Serializable)controllingDoc -> {
                MetadataValidator.$anonfun$validateSObjectLike$7(this, controllingDocs, controllingDoc);
                return BoxedUnit.UNIT;
            });
        }
        this.assertUniqueName(FieldNature$.MODULE$, (List<MetadataDocument>)allDocs);
        this.assertUniqueName(FieldSetNature$.MODULE$, (List<MetadataDocument>)allDocs);
        this.assertUniqueName(SharingReasonNature$.MODULE$, (List<MetadataDocument>)allDocs);
    }

    private void assertUniqueName(MetadataNature nature, List<MetadataDocument> documents) {
        ((IterableOnceOps)documents.filter((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$assertUniqueName$1(nature, x$20))).groupBy((Function1 & Serializable)x$21 -> x$21.name()).filter((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$assertUniqueName$3(x$22)))).foreach((Function1 & Serializable)duplicate -> {
            MetadataValidator.$anonfun$assertUniqueName$4(this, duplicate);
            return BoxedUnit.UNIT;
        });
    }

    private void validateCaseSensitivity(List<PathLike> documents, String expectedDirectoryName) {
        documents.foreach((Function1 & Serializable)document -> {
            MetadataValidator.$anonfun$validateCaseSensitivity$1(this, expectedDirectoryName, document);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$validateApex$3(MetadataDocument controllingDoc$1, MetadataDocument x$2) {
        MetadataDocument metadataDocument = x$2;
        MetadataDocument metadataDocument2 = controllingDoc$1;
        return !(metadataDocument != null ? !metadataDocument.equals(metadataDocument2) : metadataDocument2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateTrigger$3(MetadataDocument controllingDoc$2, MetadataDocument x$4) {
        MetadataDocument metadataDocument = x$4;
        MetadataDocument metadataDocument2 = controllingDoc$2;
        return !(metadataDocument != null ? !metadataDocument.equals(metadataDocument2) : metadataDocument2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getSingleControllingDocument$1(MetadataNature controllingNature$1, MetadataDocument x$5) {
        MetadataNature metadataNature = x$5.nature();
        MetadataNature metadataNature2 = controllingNature$1;
        return !(metadataNature != null ? !metadataNature.equals(metadataNature2) : metadataNature2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getSingleControllingDocument$2(MetadataNature metaNature$1, MetadataDocument x$6) {
        MetadataNature metadataNature = x$6.nature();
        MetadataNature metadataNature2 = metaNature$1;
        return !(metadataNature != null ? !metadataNature.equals(metadataNature2) : metadataNature2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getSingleControllingDocument$3(MetadataDocument md) {
        PathLike controllingPath;
        PathLike pathLike = controllingPath = md.path().parent().join((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{md.path().basename().replaceFirst("-meta.xml$", "")}));
        PathLike pathLike2 = md.path();
        return (pathLike == null ? pathLike2 != null : !pathLike.equals(pathLike2)) && controllingPath.isFile();
    }

    public static final /* synthetic */ void $anonfun$getSingleControllingDocument$4(MetadataValidator $this, MetadataDocument document) {
        TypeName typeName = document.typeName($this.namespace);
        $this.logger.log(new Issue(document.path(), new Diagnostic(ERROR_CATEGORY$.MODULE$, Location$.MODULE$.empty(), new StringBuilder(66).append("Type '").append(typeName).append("' is not defined, but expected due to '").append(document.path()).append("', ignoring this file").toString()), Issue$.MODULE$.apply$default$3()));
    }

    public static final /* synthetic */ boolean $anonfun$getSingleControllingDocument$6(MetadataDocument document$1, MetadataDocument x$7) {
        PathLike pathLike = x$7.path();
        PathLike pathLike2 = document$1.path();
        return !(pathLike != null ? !pathLike.equals(pathLike2) : pathLike2 != null);
    }

    public static final /* synthetic */ void $anonfun$getSingleControllingDocument$5(MetadataValidator $this, List controllingDocs$1, MetadataDocument document) {
        TypeName typeName = document.typeName($this.namespace);
        String otherPaths = controllingDocs$1.filterNot((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$getSingleControllingDocument$6(document, x$7))).map((Function1 & Serializable)x$8 -> x$8.path()).mkString(", ");
        $this.logger.log(new Issue(document.path(), new Diagnostic(ERROR_CATEGORY$.MODULE$, Location$.MODULE$.empty(), new StringBuilder(64).append("Duplicate for type '").append(typeName).append("' found in '").append(document.path()).append("', ignoring this file, see also ").append(otherPaths).toString()), Issue$.MODULE$.apply$default$3()));
    }

    public static final /* synthetic */ boolean $anonfun$assertSingleMetaDocument$1(MetadataNature nature$1, MetadataDocument x$9) {
        MetadataNature metadataNature = x$9.nature();
        MetadataNature metadataNature2 = nature$1;
        return !(metadataNature != null ? !metadataNature.equals(metadataNature2) : metadataNature2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$assertSingleDocument$3(MetadataDocument document$2, PathLike x$12) {
        PathLike pathLike = x$12;
        PathLike pathLike2 = document$2.path();
        return !(pathLike != null ? !pathLike.equals(pathLike2) : pathLike2 != null);
    }

    public static final /* synthetic */ void $anonfun$assertSingleDocument$2(MetadataValidator $this, List documents$1, MetadataDocument document) {
        String otherPaths = documents$1.filterNot((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$assertSingleDocument$3(document, x$12))).mkString(", ");
        $this.logger.log(new Issue(document.path(), new Diagnostic(ERROR_CATEGORY$.MODULE$, Location$.MODULE$.empty(), new StringBuilder(32).append("Duplicate for type '").append(document.typeName($this.namespace)).append("', see also ").append(otherPaths).toString()), Issue$.MODULE$.apply$default$3()));
    }

    public static final /* synthetic */ boolean $anonfun$validateSObjectLike$2(MetadataDocument x$14) {
        MetadataNature metadataNature = x$14.nature();
        SObjectNature$ sObjectNature$ = SObjectNature$.MODULE$;
        return !(metadataNature != null ? !metadataNature.equals(sObjectNature$) : sObjectNature$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateSObjectLike$3(MetadataDocument x$15) {
        return x$15 instanceof SObjectDocument;
    }

    public static final /* synthetic */ boolean $anonfun$validateSObjectLike$5(Name x$16) {
        String string = x$16.value();
        String string2 = "c";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateSObjectLike$8(MetadataDocument controllingDoc$3, MetadataDocument x$18) {
        MetadataDocument metadataDocument = x$18;
        MetadataDocument metadataDocument2 = controllingDoc$3;
        return !(metadataDocument != null ? !metadataDocument.equals(metadataDocument2) : metadataDocument2 != null);
    }

    public static final /* synthetic */ void $anonfun$validateSObjectLike$7(MetadataValidator $this, List controllingDocs$2, MetadataDocument controllingDoc) {
        TypeName typeName = controllingDoc.typeName($this.namespace);
        String otherPaths = controllingDocs$2.filterNot((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$validateSObjectLike$8(controllingDoc, x$18))).map((Function1 & Serializable)x$19 -> x$19.path()).mkString(", ");
        $this.logger.log(new Issue(controllingDoc.path(), new Diagnostic(ERROR_CATEGORY$.MODULE$, Location$.MODULE$.empty(), new StringBuilder(65).append("Type '").append(typeName).append("' is defined, but duplicate object-meta.xml files found at ").append(otherPaths).toString()), Issue$.MODULE$.apply$default$3()));
    }

    public static final /* synthetic */ boolean $anonfun$assertUniqueName$1(MetadataNature nature$2, MetadataDocument x$20) {
        MetadataNature metadataNature = x$20.nature();
        MetadataNature metadataNature2 = nature$2;
        return !(metadataNature != null ? !metadataNature.equals(metadataNature2) : metadataNature2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$assertUniqueName$3(Tuple2 x$22) {
        return ((SeqOps)x$22._2()).size() > 1;
    }

    public static final /* synthetic */ boolean $anonfun$assertUniqueName$6(MetadataDocument duplicated$1, MetadataDocument x$23) {
        MetadataDocument metadataDocument = x$23;
        MetadataDocument metadataDocument2 = duplicated$1;
        return !(metadataDocument != null ? !metadataDocument.equals(metadataDocument2) : metadataDocument2 != null);
    }

    public static final /* synthetic */ void $anonfun$assertUniqueName$5(MetadataValidator $this, Tuple2 duplicate$1, MetadataDocument duplicated) {
        TypeName typeName = duplicated.typeName($this.namespace);
        String otherPaths = ((List)duplicate$1._2()).filterNot((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)MetadataValidator.$anonfun$assertUniqueName$6(duplicated, x$23))).map((Function1 & Serializable)x$24 -> x$24.path()).mkString(", ");
        $this.logger.log(new Issue(duplicated.path(), new Diagnostic(ERROR_CATEGORY$.MODULE$, Location$.MODULE$.empty(), new StringBuilder(52).append("Type '").append(typeName.toString()).append("' is defined, but duplicate metadata found at ").append(otherPaths).toString()), Issue$.MODULE$.apply$default$3()));
    }

    public static final /* synthetic */ void $anonfun$assertUniqueName$4(MetadataValidator $this, Tuple2 duplicate) {
        ((List)duplicate._2()).foreach((Function1 & Serializable)duplicated -> {
            MetadataValidator.$anonfun$assertUniqueName$5($this, duplicate, duplicated);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$validateCaseSensitivity$1(MetadataValidator $this, String expectedDirectoryName$1, PathLike document) {
        String parentDir = document.parent().basename();
        if (parentDir.equalsIgnoreCase(expectedDirectoryName$1)) {
            String string = parentDir;
            String string2 = expectedDirectoryName$1;
            if (string == null ? string2 != null : !string.equals(string2)) {
                $this.logger.log(new Issue(document, new Diagnostic(ERROR_CATEGORY$.MODULE$, Location$.MODULE$.empty(), new StringBuilder(174).append("Directory name case mismatch: found '").append(parentDir).append("' but should be '").append(expectedDirectoryName$1).append("'. ").append("SFDX metadata directories should follow the correct case convention for consistency and cross-platform compatibility.").toString()), Issue$.MODULE$.apply$default$3()));
                return;
            }
        }
    }

    public MetadataValidator(IssueLogger logger, Option<Name> namespace, boolean isGulped) {
        this.logger = logger;
        this.namespace = namespace;
        this.isGulped = isGulped;
    }
}

