/*
 * Decompiled with CFR 0.152.
 */
package com.nawforce.pkgforce.workspace;

import com.nawforce.pkgforce.diagnostics.IssueLogger;
import com.nawforce.pkgforce.diagnostics.IssueLogger$;
import com.nawforce.pkgforce.path.Location$;
import com.nawforce.pkgforce.path.PathLike;
import com.nawforce.pkgforce.sfdx.ForceIgnoreVersion;
import com.nawforce.pkgforce.sfdx.ForceIgnoreVersion$;
import com.nawforce.pkgforce.sfdx.SFDXProject;
import com.nawforce.pkgforce.sfdx.SFDXProject$;
import com.nawforce.pkgforce.workspace.NamespaceLayer;
import com.nawforce.pkgforce.workspace.ProjectConfig;
import com.nawforce.pkgforce.workspace.Workspace;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Workspace$
implements Serializable {
    public static final Workspace$ MODULE$ = new Workspace$();

    public Option<ProjectConfig> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public Seq<PathLike> $lessinit$greater$default$4() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public ForceIgnoreVersion $lessinit$greater$default$5() {
        return ForceIgnoreVersion$.MODULE$.default();
    }

    public Option<Workspace> apply(Option<SFDXProject> project, IssueLogger issueManager) {
        Seq layers = (Seq)project.map((Function1 & Serializable)x$2 -> x$2.layers(issueManager)).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
        if (issueManager.hasErrors()) {
            return None$.MODULE$;
        }
        return project.map((Function1 & Serializable)proj -> new Workspace(issueManager, (Seq<NamespaceLayer>)layers, (Option<ProjectConfig>)new Some((Object)new ProjectConfig(proj.maxDependencyCount(), proj.isLibrary())), proj.externalMetadataPaths(), proj.forceIgnoreVersion()));
    }

    public Tuple2<Option<Workspace>, IssueLogger> apply(PathLike path) {
        IssueLogger logger = new IssueLogger(IssueLogger$.MODULE$.$lessinit$greater$default$1());
        Option<Tuple2<Option<Workspace>, IssueLogger>> option = this.validateWorkspacePath(path, logger);
        if (option instanceof Some) {
            Some some = (Some)option;
            Tuple2 error = (Tuple2)some.value();
            return error;
        }
        if (None$.MODULE$.equals(option)) {
            return this.createWorkspaceFromValidPath(path, logger);
        }
        throw new MatchError(option);
    }

    public Option<ProjectConfig> apply$default$3() {
        return None$.MODULE$;
    }

    public Seq<PathLike> apply$default$4() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public ForceIgnoreVersion apply$default$5() {
        return ForceIgnoreVersion$.MODULE$.default();
    }

    private Option<Tuple2<Option<Workspace>, IssueLogger>> validateWorkspacePath(PathLike path, IssueLogger logger) {
        if (!path.exists() || !path.isDirectory()) {
            logger.logError(path, Location$.MODULE$.empty(), new StringBuilder(16).append("No directory at ").append(path).toString());
            IssueLogger issueManager = new IssueLogger((Option<Function1<PathLike, Object>>)None$.MODULE$);
            logger.issues().foreach((Function1 & Serializable)issue -> {
                issueManager.add(issue);
                return BoxedUnit.UNIT;
            });
            return new Some((Object)new Tuple2((Object)None$.MODULE$, (Object)issueManager));
        }
        return None$.MODULE$;
    }

    private Tuple2<Option<Workspace>, IssueLogger> createWorkspaceFromValidPath(PathLike path, IssueLogger logger) {
        Option<SFDXProject> project = this.loadSFDXProject(path, logger);
        Option<Function1<PathLike, Object>> externalPathFilter = this.createExternalPathFilter(project);
        IssueLogger issueManager = new IssueLogger(externalPathFilter);
        logger.issues().foreach((Function1 & Serializable)issue -> {
            issueManager.add(issue);
            return BoxedUnit.UNIT;
        });
        return new Tuple2(this.apply(project, issueManager), (Object)issueManager);
    }

    private Option<SFDXProject> loadSFDXProject(PathLike path, IssueLogger logger) {
        if (path.join((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sfdx-project.json"})).exists()) {
            return SFDXProject$.MODULE$.apply(path, logger);
        }
        logger.logError(path, Location$.MODULE$.empty(), new StringBuilder(72).append("No sfdx-project.json found at ").append(path).append(". Only SFDX format projects are supported.").toString());
        return None$.MODULE$;
    }

    private Option<Function1<PathLike, Object>> createExternalPathFilter(Option<SFDXProject> project) {
        Seq externalPaths = (Seq)((IterableOps)project.map((Function1 & Serializable)x$3 -> x$3.externalMetadataPaths()).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty())).map((Function1 & Serializable)x$4 -> x$4.toString());
        if (externalPaths.nonEmpty()) {
            return new Some((Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)externalPaths.exists((Function1 & Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)Workspace$.$anonfun$createExternalPathFilter$5(path, prefix)))));
        }
        return None$.MODULE$;
    }

    public Workspace apply(IssueLogger logger, Seq<NamespaceLayer> layers, Option<ProjectConfig> projectConfig, Seq<PathLike> externalMetadataPaths, ForceIgnoreVersion forceIgnoreVersion) {
        return new Workspace(logger, layers, projectConfig, externalMetadataPaths, forceIgnoreVersion);
    }

    public Option<Tuple5<IssueLogger, Seq<NamespaceLayer>, Option<ProjectConfig>, Seq<PathLike>, ForceIgnoreVersion>> unapply(Workspace x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5((Object)x$0.logger(), x$0.layers(), x$0.projectConfig(), x$0.externalMetadataPaths(), (Object)x$0.forceIgnoreVersion()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Workspace$.class);
    }

    public static final /* synthetic */ boolean $anonfun$createExternalPathFilter$5(PathLike path$1, String prefix) {
        return path$1.toString().startsWith(prefix);
    }

    private Workspace$() {
    }
}

