/*
 * Decompiled with CFR 0.152.
 */
package io.github.apexdevtools.apexls.types;

import com.financialforce.types.IFormalParameter;
import com.financialforce.types.IMethodDeclaration;
import com.financialforce.types.base.Location;
import com.financialforce.types.base.TypeRef;
import io.github.apexdevtools.apexls.api.ApexMethod;
import io.github.apexdevtools.apexls.api.ApexMethodParameter;
import io.github.apexdevtools.apexls.api.ApexType;
import io.github.apexdevtools.apexls.api.ApexTypeId;
import io.github.apexdevtools.apexls.types.ApexLocationAdapter;
import io.github.apexdevtools.apexls.types.ApexMethodParameterAdapter;
import io.github.apexdevtools.apexls.types.ApexTypeAdapter;
import io.github.apexdevtools.apexls.types.NameApexTypeId;
import java.util.Arrays;
import java.util.List;
import scala.Option;
import scala.collection.immutable.ArraySeq;

public class ApexMethodAdapter
implements ApexMethod {
    private static final NameApexTypeId VOID_APEX_TYPE_ID = new NameApexTypeId("void", "", false);
    private final IMethodDeclaration md;
    private final ApexTypeAdapter definingType;

    public ApexMethodAdapter(ApexTypeAdapter apexTypeAdapter, IMethodDeclaration iMethodDeclaration) {
        this.definingType = apexTypeAdapter;
        this.md = iMethodDeclaration;
    }

    @Override
    public String getMethodName() {
        return this.md.id().toString();
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public String getModifiers() {
        return this.md.annotationsAndModifiers();
    }

    @Override
    public ApexTypeId getReturnType() {
        if (this.md.typeRef().isEmpty()) {
            return VOID_APEX_TYPE_ID;
        }
        return NameApexTypeId.apply((Option<TypeRef>)this.md.typeRef());
    }

    @Override
    public List<ApexMethodParameter> getParameters() {
        ArraySeq arraySeq = this.md.formalParameters();
        ApexMethodParameter[] apexMethodParameterArray = new ApexMethodParameter[arraySeq.length()];
        for (int i = 0; i < arraySeq.length(); ++i) {
            apexMethodParameterArray[i] = new ApexMethodParameterAdapter((IFormalParameter)arraySeq.apply(i));
        }
        return Arrays.asList(apexMethodParameterArray);
    }

    @Override
    public ApexLocationAdapter getLocation() {
        return new ApexLocationAdapter((Location)this.md.bodyLocation().get());
    }

    @Override
    public ApexType getDefiningType() {
        return this.definingType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ApexMethodAdapter apexMethodAdapter = (ApexMethodAdapter)object;
        return this.md == apexMethodAdapter.md && this.definingType == apexMethodAdapter.definingType;
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + this.md.hashCode();
        n = 31 * n + this.definingType.hashCode();
        return n;
    }
}

