/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cli.commands.internal;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.AbstractConfiguration;
import net.sourceforge.pmd.cli.commands.internal.AbstractPmdSubcommand;
import net.sourceforge.pmd.cli.commands.internal.PmdCommand;
import net.sourceforge.pmd.cli.internal.CliExitCode;
import net.sourceforge.pmd.cli.internal.PmdRootLogger;
import net.sourceforge.pmd.util.log.PmdReporter;
import net.sourceforge.pmd.util.log.internal.SimpleMessageReporter;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public abstract class AbstractAnalysisPmdSubcommand<C extends AbstractConfiguration>
extends AbstractPmdSubcommand {
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;
    protected static final String FILE_COLLECTION_OPTION_HEADER = "Input files specification";
    @CommandLine.Option(names={"--no-fail-on-violation"}, description={"By default PMD exits with status 4 if violations or duplications are found. Disable this option with '--no-fail-on-violation' to exit with 0 instead. In any case a report with the found violations or duplications will be written."}, defaultValue="true", negatable=true)
    private boolean failOnViolation;
    @CommandLine.Option(names={"--no-fail-on-error"}, description={"By default PMD exits with status 5 if recoverable errors occurred (whether or not there are violations or duplications). Disable this option with '--no-fail-on-error' to exit with 0 instead. In any case, a report with the found violations or duplications will be written."}, defaultValue="true", negatable=true)
    private boolean failOnError;
    @CommandLine.Option(names={"--report-file", "-r"}, description={"Path to a file to which report output is written. The file is created if it does not exist. If this option is not specified, the report is rendered to standard output."})
    private Path reportFile;

    protected abstract C toConfiguration();

    protected abstract CliExitCode doExecute(C var1);

    @Override
    protected CliExitCode execute() {
        C configuration = this.toConfiguration();
        return PmdRootLogger.executeInLoggingContext(configuration, this.debug, this::doExecute);
    }

    protected abstract FileCollectionOptions<C> getFileCollectionOptions();

    @Override
    protected void validate() throws CommandLine.ParameterException {
        super.validate();
        this.getFileCollectionOptions().validate(this.spec);
    }

    protected final void setCommonConfigProperties(C configuration) {
        SimpleMessageReporter reporter = new SimpleMessageReporter(LoggerFactory.getLogger(PmdCommand.class));
        configuration.setReporter((PmdReporter)reporter);
        this.getFileCollectionOptions().configureFilesToAnalyze(configuration);
        configuration.setReportFile(this.reportFile);
        configuration.setFailOnViolation(this.failOnViolation);
        configuration.setFailOnError(this.failOnError);
    }

    protected static class FileCollectionOptions<C extends AbstractConfiguration> {
        @CommandLine.Option(names={"--encoding", "-e"}, description={"Specifies the character set encoding of the source code files"}, defaultValue="UTF-8")
        private Charset encoding;
        @CommandLine.Option(names={"--file-list"}, description={"Path to a file containing a list of files to analyze, one path per line. One of --dir, --file-list or --uri must be provided."})
        private Path fileListPath;
        @CommandLine.Option(names={"--uri", "-u"}, description={"Database URI for sources. One of --dir, --file-list or --uri must be provided."})
        private URI uri;
        boolean usesDeprecatedIgnoreListOption = false;
        @CommandLine.Option(names={"--exclude"}, arity="1..*", description={"Files to be excluded from the analysis"})
        private List<Path> excludeFiles = new ArrayList<Path>();
        @CommandLine.Option(names={"--exclude-file-list"}, description={"Path to a file containing a list of files to exclude from the analysis, one path per line. This option can be combined with --dir, --file-list and --uri."})
        private Path excludeFileListPath;
        @CommandLine.Option(names={"--relativize-paths-with", "-z"}, description={"Path relative to which directories are rendered in the report. This option allows shortening directories in the report; without it, paths are rendered as mentioned in the source directory (option \"--dir\"). The option can be repeated, in which case the shortest relative path will be used. If the root path is mentioned (e.g. \"/\" or \"C:\\\"), then the paths will be rendered as absolute."}, arity="1..*", split=",")
        private List<Path> relativizeRootPaths;
        private Set<Path> inputPaths;
        @CommandLine.Option(names={"--non-recursive"}, description={"Don't scan subdirectiories when using the --d (-dir) option."})
        private boolean nonRecursive;

        protected FileCollectionOptions() {
        }

        @CommandLine.Option(names={"--ignore-list"}, description={"(DEPRECATED: use --exclude-file-list) Path to a file containing a list of files to exclude from the analysis, one path per line. This option can be combined with --dir, --file-list and --uri."})
        @Deprecated
        protected void setExcludeFileList(Path path) {
            this.excludeFileListPath = path;
            this.usesDeprecatedIgnoreListOption = true;
        }

        @CommandLine.Option(names={"--dir", "-d"}, description={"Path to a source file, or directory containing source files to analyze. Zip and Jar files are also supported, if they are specified directly (archive files found while exploring a directory are not recursively expanded). This option can be repeated, and multiple arguments can be provided to a single occurrence of the option. One of --dir, --file-list or --uri must be provided."}, arity="1..*", split=",")
        protected void setInputPaths(List<Path> inputPaths) {
            if (this.inputPaths == null) {
                this.inputPaths = new LinkedHashSet<Path>();
            }
            this.inputPaths.addAll(inputPaths);
        }

        @CommandLine.Parameters(arity="*", description={"Path to a source file, or directory containing source files to analyze. Equivalent to using --dir."})
        protected void setPositionalInputPaths(List<Path> inputPaths) {
            this.setInputPaths(inputPaths);
        }

        protected void configureFilesToAnalyze(C configuration) {
            if (this.inputPaths != null) {
                configuration.setInputPathList(new ArrayList<Path>(this.inputPaths));
            }
            configuration.setExcludes(this.excludeFiles);
            configuration.collectFilesRecursively(!this.nonRecursive);
            configuration.setInputFilePath(this.fileListPath);
            configuration.setIgnoreFilePath(this.excludeFileListPath);
            configuration.setInputUri(this.uri);
            if (this.relativizeRootPaths != null) {
                configuration.addRelativizeRoots(this.relativizeRootPaths);
            }
            configuration.setSourceEncoding(this.encoding);
            if (this.usesDeprecatedIgnoreListOption) {
                configuration.getReporter().warn("Option name --ignore-list is deprecated. Use --exclude-file-list instead.", new Object[0]);
            }
        }

        protected void validate(CommandLine.Model.CommandSpec spec) throws CommandLine.ParameterException {
            if ((this.inputPaths == null || this.inputPaths.isEmpty()) && this.uri == null && this.fileListPath == null) {
                throw new CommandLine.ParameterException(spec.commandLine(), "Please provide a parameter for source root directory (--dir or -d), database URI (--uri or -u), or file list path (--file-list)");
            }
            if (this.relativizeRootPaths != null) {
                for (Path path : this.relativizeRootPaths) {
                    if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                    throw new CommandLine.ParameterException(spec.commandLine(), "Expected a directory path for option '--relativize-paths-with', found a file: " + path);
                }
            }
        }
    }
}

