/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cli.commands.typesupport.internal;

import picocli.CommandLine;

public class NumThreadsConverter
implements CommandLine.ITypeConverter<Integer> {
    public Integer convert(String s) {
        boolean isCoreMultiplied = s.endsWith("C");
        if (isCoreMultiplied) {
            s = s.substring(0, s.length() - 1);
            try {
                float f = Float.parseFloat(s);
                return (int)(f * (float)Runtime.getRuntime().availableProcessors());
            }
            catch (NumberFormatException e) {
                throw new CommandLine.TypeConversionException("'" + s + "' is not a float or integer");
            }
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new CommandLine.TypeConversionException("'" + s + "' is not an integer");
        }
    }
}

