/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.modelica.resolver;

import net.sourceforge.pmd.lang.modelica.ast.ASTComponentClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTComponentDeclaration;
import net.sourceforge.pmd.lang.modelica.ast.ASTConditionAttribute;
import net.sourceforge.pmd.lang.modelica.ast.ASTConstantClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTDeclaration;
import net.sourceforge.pmd.lang.modelica.ast.ASTDiscreteClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTFlowClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTInputClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTName;
import net.sourceforge.pmd.lang.modelica.ast.ASTOutputClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTParameterClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTSimpleName;
import net.sourceforge.pmd.lang.modelica.ast.ASTStreamClause;
import net.sourceforge.pmd.lang.modelica.ast.ASTTypePrefix;
import net.sourceforge.pmd.lang.modelica.ast.ASTTypeSpecifier;
import net.sourceforge.pmd.lang.modelica.resolver.AbstractModelicaDeclaration;
import net.sourceforge.pmd.lang.modelica.resolver.CompositeName;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaClassScope;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaDeclaration;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaType;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionResult;
import net.sourceforge.pmd.lang.modelica.resolver.internal.ResolutionContext;
import net.sourceforge.pmd.lang.modelica.resolver.internal.ResolutionState;
import net.sourceforge.pmd.lang.modelica.resolver.internal.Watchdog;

public class ModelicaComponentDeclaration
extends AbstractModelicaDeclaration
implements ModelicaDeclaration {
    private ModelicaClassScope containingScope;
    private ComponentKind kind;
    private ComponentVariability variability;
    private ComponentCausality causality;
    private final ASTName typeName;
    private ResolutionResult<ModelicaType> typeCandidates;
    private final String declarationName;
    private final ASTConditionAttribute condition;

    public ModelicaComponentDeclaration(ASTComponentDeclaration node) {
        this.declarationName = ((ASTSimpleName)((ASTDeclaration)node.firstChild(ASTDeclaration.class)).firstChild(ASTSimpleName.class)).getName();
        this.condition = (ASTConditionAttribute)node.firstChild(ASTConditionAttribute.class);
        ASTComponentClause declarationRoot = (ASTComponentClause)node.ancestors(ASTComponentClause.class).first();
        ASTTypePrefix prefixes = (ASTTypePrefix)declarationRoot.firstChild(ASTTypePrefix.class);
        this.parseTypePrefix(prefixes);
        this.typeName = (ASTName)((ASTTypeSpecifier)declarationRoot.firstChild(ASTTypeSpecifier.class)).firstChild(ASTName.class);
    }

    void setContainingScope(ModelicaClassScope scope) {
        this.containingScope = scope;
    }

    @Override
    public ModelicaClassScope getContainingScope() {
        return this.containingScope;
    }

    private void parseTypePrefix(ASTTypePrefix prefix) {
        this.kind = prefix.firstChild(ASTFlowClause.class) != null ? ComponentKind.FLOW : (prefix.firstChild(ASTStreamClause.class) != null ? ComponentKind.STREAM : ComponentKind.NOTHING_SPECIAL);
        this.variability = prefix.firstChild(ASTDiscreteClause.class) != null ? ComponentVariability.DISCRETE : (prefix.firstChild(ASTParameterClause.class) != null ? ComponentVariability.PARAMETER : (prefix.firstChild(ASTConstantClause.class) != null ? ComponentVariability.CONSTANT : ComponentVariability.CONTINUOUS));
        this.causality = prefix.firstChild(ASTInputClause.class) != null ? ComponentCausality.INPUT : (prefix.firstChild(ASTOutputClause.class) != null ? ComponentCausality.OUTPUT : ComponentCausality.ACAUSAL);
    }

    public ASTConditionAttribute getCondition() {
        return this.condition;
    }

    public ComponentKind getKind() {
        return this.kind;
    }

    public ComponentVariability getVariability() {
        return this.variability;
    }

    public ComponentCausality getCausality() {
        return this.causality;
    }

    @Override
    public String getSimpleDeclarationName() {
        return this.declarationName;
    }

    @Override
    public String getDescriptiveName() {
        return this.declarationName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.kind != null) {
            sb.append(this.kind.toString());
            sb.append(' ');
        }
        if (this.variability != null) {
            sb.append(this.variability.toString());
            sb.append(' ');
        }
        if (this.causality != null) {
            sb.append(this.causality.toString());
            sb.append(' ');
        }
        sb.append(this.typeName);
        sb.append(' ');
        sb.append(this.declarationName);
        return sb.toString();
    }

    public ResolutionResult<ModelicaType> getTypeCandidates() {
        if (this.typeCandidates == null) {
            ResolutionContext ctx = ResolutionState.forComponentReference().createContext();
            try {
                this.getContainingScope().resolveLexically(ctx, this.typeName.getCompositeName());
            }
            catch (Watchdog.CountdownException e) {
                ctx.markTtlExceeded();
            }
            this.typeCandidates = ctx.getTypes();
        }
        return this.typeCandidates;
    }

    @Override
    void resolveFurtherNameComponents(ResolutionContext result, CompositeName name) throws Watchdog.CountdownException {
        if (name.isEmpty()) {
            result.addCandidate(this);
            return;
        }
        ResolutionResult<ModelicaType> resolvedType = this.getTypeCandidates();
        for (ModelicaType decl : resolvedType.getBestCandidates()) {
            ((AbstractModelicaDeclaration)((Object)decl)).resolveFurtherNameComponents(result, name);
        }
        result.markHidingPoint();
        for (ModelicaType decl : resolvedType.getHiddenCandidates()) {
            ((AbstractModelicaDeclaration)((Object)decl)).resolveFurtherNameComponents(result, name);
        }
    }

    public static enum ComponentKind {
        FLOW("flow"),
        STREAM("stream"),
        NOTHING_SPECIAL("");

        private String name;

        private ComponentKind(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum ComponentVariability {
        DISCRETE("discrete"),
        PARAMETER("parameter"),
        CONSTANT("constant"),
        CONTINUOUS("continuous");

        private String name;

        private ComponentVariability(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum ComponentCausality {
        INPUT("input"),
        OUTPUT("output"),
        ACAUSAL("acausal");

        private String name;

        private ComponentCausality(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

