/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Objects;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextRange2d;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Mark
implements Comparable<Mark> {
    private final @NonNull TokenEntry token;
    private @Nullable TokenEntry endToken;

    Mark(@NonNull TokenEntry token) {
        this.token = token;
    }

    @NonNull TokenEntry getToken() {
        return this.token;
    }

    @NonNull TokenEntry getEndToken() {
        return this.endToken == null ? this.token : this.endToken;
    }

    public FileLocation getLocation() {
        TokenEntry endToken = this.getEndToken();
        return FileLocation.range(this.getFileId(), TextRange2d.range2d(this.token.getBeginLine(), this.token.getBeginColumn(), endToken.getEndLine(), endToken.getEndColumn()));
    }

    FileId getFileId() {
        return this.token.getFileId();
    }

    public int getBeginTokenIndex() {
        return this.token.getIndex();
    }

    public int getEndTokenIndex() {
        return this.getEndToken().getIndex();
    }

    void setEndToken(@NonNull TokenEntry endToken) {
        assert (endToken.getFileId().equals(this.token.getFileId())) : "Tokens are not from the same file";
        this.endToken = endToken;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.token.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Mark other = (Mark)obj;
        return Objects.equals(this.token, other.token) && Objects.equals(this.endToken, other.endToken);
    }

    @Override
    public int compareTo(Mark other) {
        return this.getToken().compareTo(other.getToken());
    }
}

