/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.internal.util.IOUtil;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.document.TextRegion;
import net.sourceforge.pmd.reporting.FileNameRenderer;

class SourceManager
implements AutoCloseable {
    private final Map<TextFile, SoftReference<TextDocument>> files = new ConcurrentHashMap<TextFile, SoftReference<TextDocument>>();
    private final Map<FileId, TextFile> fileByPathId = new HashMap<FileId, TextFile>();
    private final List<TextFile> textFiles;
    private FileNameRenderer fileNameRenderer = FileId::getAbsolutePath;

    SourceManager(List<? extends TextFile> files) {
        this.textFiles = new ArrayList<TextFile>(files);
        files.forEach(f -> this.fileByPathId.put(f.getFileId(), (TextFile)f));
    }

    List<TextFile> getTextFiles() {
        return this.textFiles;
    }

    boolean isEmpty() {
        return this.textFiles.isEmpty();
    }

    private TextDocument load(TextFile file) {
        try {
            return TextDocument.create(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    TextDocument get(TextFile file) {
        TextDocument textDocument = (TextDocument)this.files.computeIfAbsent(file, f -> new SoftReference<TextDocument>(this.load((TextFile)f))).get();
        if (textDocument == null) {
            TextDocument doc = this.load(file);
            this.files.put(file, new SoftReference<TextDocument>(doc));
            return doc;
        }
        return textDocument;
    }

    int size() {
        return this.files.size();
    }

    @Override
    public void close() throws IOException {
        Exception exception = IOUtil.closeAll(this.textFiles);
        if (exception != null) {
            throw new IOException(exception);
        }
    }

    Chars getSlice(Mark mark) {
        TextFile textFile = this.fileByPathId.get(mark.getToken().getFileId());
        assert (textFile != null) : "No such file " + mark.getToken().getFileId();
        TextDocument doc = this.get(textFile);
        assert (doc != null);
        FileLocation loc = mark.getLocation();
        TextRegion lineRange = doc.createLineRange(loc.getStartLine(), loc.getEndLine());
        return doc.sliceOriginalText(lineRange);
    }

    String getFileDisplayName(FileId fileId) {
        return this.fileNameRenderer.getDisplayName(fileId);
    }
}

