/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.internal.util;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.sourceforge.pmd.internal.util.FileExtensionFilter;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PredicateUtil {
    private PredicateUtil() {
    }

    public static <T> Predicate<T> never() {
        return t -> false;
    }

    public static <T> Predicate<T> always() {
        return t -> true;
    }

    public static Predicate<String> getFileExtensionFilter(String ... extensions) {
        AssertionUtil.requireParamNotNull("extensions", extensions);
        AssertionUtil.requireOver1("Extension count", extensions.length);
        return new FileExtensionFilter(true, extensions);
    }

    public static Predicate<String> toNormalizedFileFilter(Predicate<? super String> filter) {
        return path -> {
            path = path.replace('\\', '/');
            return filter.test((String)path);
        };
    }

    public static Predicate<String> buildRegexFilterIncludeOverExclude(@NonNull Collection<Pattern> includeRegexes, @NonNull Collection<Pattern> excludeRegexes) {
        AssertionUtil.requireParamNotNull("includeRegexes", includeRegexes);
        AssertionUtil.requireParamNotNull("excludeRegexes", includeRegexes);
        return PredicateUtil.union(excludeRegexes).negate().or(PredicateUtil.union(includeRegexes));
    }

    private static Predicate<String> union(Collection<Pattern> regexes) {
        return regexes.stream().map(PredicateUtil::matchesRegex).reduce(PredicateUtil.never(), Predicate::or);
    }

    private static Predicate<String> matchesRegex(Pattern regex) {
        return s -> regex.matcher((CharSequence)s).matches();
    }
}

