/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.io.IOException;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.internal.util.ClasspathClassLoader;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public class JvmLanguagePropertyBundle
extends LanguagePropertyBundle {
    public static final PropertyDescriptor<String> AUX_CLASSPATH = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty("auxClasspath").desc("A classpath to use to resolve references to external types in the analysed sources. Individual paths are separated by ; on Windows and : on other platforms. All classes of the analysed project should be found on this classpath, including the compiled classes corresponding to the analyzed sources themselves, and the JDK classes.")).defaultValue("")).build();
    private ClassLoader classLoader;

    public JvmLanguagePropertyBundle(Language language) {
        super(language);
        this.definePropertyDescriptor(AUX_CLASSPATH);
    }

    @Override
    public <T> void setProperty(PropertyDescriptor<T> propertyDescriptor, T value) {
        super.setProperty(propertyDescriptor, value);
        if (propertyDescriptor == AUX_CLASSPATH) {
            this.classLoader = null;
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public @NonNull ClassLoader getAnalysisClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        this.classLoader = PMDConfiguration.class.getClassLoader();
        String classpath = this.getProperty(AUX_CLASSPATH);
        if (StringUtils.isNotBlank((CharSequence)classpath)) {
            try {
                this.classLoader = new ClasspathClassLoader(classpath, this.classLoader);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.classLoader;
    }
}

