/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.cache.internal.AnalysisCache;
import net.sourceforge.pmd.lang.LanguageProcessorRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.PmdCapableLanguage;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.rule.internal.RuleSets;
import net.sourceforge.pmd.reporting.GlobalAnalysisListener;
import net.sourceforge.pmd.util.log.PmdReporter;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface LanguageProcessor
extends AutoCloseable {
    public @NonNull LanguageVersionHandler services();

    public @NonNull AutoCloseable launchAnalysis(@NonNull AnalysisTask var1);

    public @NonNull PmdCapableLanguage getLanguage();

    public @NonNull LanguageVersion getLanguageVersion();

    public static class AnalysisTask {
        private final RuleSets rulesets;
        private final List<TextFile> files;
        private final GlobalAnalysisListener listener;
        private final int threadCount;
        private final AnalysisCache analysisCache;
        private final PmdReporter messageReporter;
        private final LanguageProcessorRegistry lpRegistry;

        AnalysisTask(RuleSets rulesets, List<TextFile> files, GlobalAnalysisListener listener, int threadCount, AnalysisCache analysisCache, PmdReporter messageReporter, LanguageProcessorRegistry lpRegistry) {
            this.rulesets = rulesets;
            this.files = files;
            this.listener = listener;
            this.threadCount = threadCount;
            this.analysisCache = analysisCache;
            this.messageReporter = messageReporter;
            this.lpRegistry = lpRegistry;
        }

        public RuleSets getRulesets() {
            return this.rulesets;
        }

        public List<TextFile> getFiles() {
            return Collections.unmodifiableList(this.files);
        }

        public GlobalAnalysisListener getListener() {
            return this.listener;
        }

        public int getThreadCount() {
            return this.threadCount;
        }

        public AnalysisCache getAnalysisCache() {
            return this.analysisCache;
        }

        public PmdReporter getMessageReporter() {
            return this.messageReporter;
        }

        public LanguageProcessorRegistry getLpRegistry() {
            return this.lpRegistry;
        }

        AnalysisTask withFiles(List<TextFile> newFiles) {
            return new AnalysisTask(this.rulesets, newFiles, this.listener, this.threadCount, this.analysisCache, this.messageReporter, this.lpRegistry);
        }
    }
}

