/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.impl.javacc;

import net.sourceforge.pmd.lang.ast.impl.javacc.BackslashEscapeTranslator;
import net.sourceforge.pmd.lang.ast.impl.javacc.MalformedSourceException;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.TextDocument;

public final class JavaEscapeTranslator
extends BackslashEscapeTranslator {
    public JavaEscapeTranslator(TextDocument input) {
        super(input);
    }

    @Override
    protected int handleBackslash(int maxOff, int firstBackslashOff) throws MalformedSourceException {
        int off;
        for (off = firstBackslashOff; off < this.input.length() && this.input.charAt(off) == '\\'; ++off) {
        }
        int bslashCount = off - firstBackslashOff;
        if ((bslashCount & 1) == 1 && off < this.input.length() && this.input.charAt(off) == 'u') {
            while (off < this.input.length() && this.input.charAt(off) == 'u') {
                ++off;
            }
            Chars value = this.escapeValue(firstBackslashOff, off - 1);
            int endOffset = off + 4;
            return this.recordEscape(firstBackslashOff, endOffset, value);
        }
        return this.abortEscape(off, maxOff);
    }

    private Chars escapeValue(int posOfFirstBackSlash, int offOfTheU) throws MalformedSourceException {
        int off = offOfTheU;
        try {
            char c = (char)(JavaEscapeTranslator.hexVal(this.input.charAt(++off)) << 12 | JavaEscapeTranslator.hexVal(this.input.charAt(++off)) << 8 | JavaEscapeTranslator.hexVal(this.input.charAt(++off)) << 4 | JavaEscapeTranslator.hexVal(this.input.charAt(++off)));
            return Chars.wrap(Character.toString(c));
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            String escape = this.input.substring(offOfTheU, Math.min(this.input.length(), offOfTheU + 5));
            throw new MalformedSourceException("Invalid unicode escape \\" + escape, e, this.locationAt(posOfFirstBackSlash));
        }
    }

    private static int hexVal(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return c - 48;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return c - 55;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return c - 87;
            }
        }
        throw new NumberFormatException("Character '" + c + "' is not a valid hexadecimal digit");
    }
}

