/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.internal;

import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.internal.IteratorBasedNStream;
import net.sourceforge.pmd.lang.ast.internal.StreamImpl;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.IteratorUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class GreedyNStream<T extends Node>
extends IteratorBasedNStream<T> {
    GreedyNStream() {
    }

    @Override
    protected <R extends Node> NodeStream<R> mapIter(Function<Iterator<T>, Iterator<R>> fun) {
        return StreamImpl.fromNonNullList(IteratorUtil.toNonNullList(fun.apply(this.iterator())));
    }

    @Override
    public T first() {
        return (T)((Node)this.toList().get(0));
    }

    @Override
    public @Nullable T get(int n) {
        AssertionUtil.requireNonNegative("n", n);
        List<T> tList = this.toList();
        return (T)(n < tList.size() ? (Node)tList.get(n) : null);
    }

    @Override
    public Iterator<T> iterator() {
        return this.toList().iterator();
    }

    @Override
    public int count() {
        return this.toList().size();
    }

    @Override
    public NodeStream<T> drop(int n) {
        if (n == 0) {
            return this;
        }
        return StreamImpl.fromNonNullList(CollectionUtil.drop(this.toList(), n));
    }

    @Override
    public NodeStream<T> take(int maxSize) {
        if (maxSize >= this.count()) {
            return this;
        }
        return StreamImpl.fromNonNullList(CollectionUtil.take(this.toList(), maxSize));
    }

    @Override
    public abstract List<T> toList();

    @Override
    public Spliterator<T> spliterator() {
        Spliterator<T> spliterator = this.toList().spliterator();
        return Spliterators.spliterator(this.iterator(), spliterator.estimateSize(), spliterator.characteristics() | 0x100);
    }

    @Override
    public NodeStream<T> cached() {
        return this;
    }

    static class GreedyKnownNStream<T extends Node>
    extends GreedyNStream<T> {
        private final List<@NonNull T> coll;

        GreedyKnownNStream(List<@NonNull T> coll) {
            this.coll = coll;
        }

        @Override
        public List<T> toList() {
            return this.coll;
        }
    }
}

