/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.internal.Filtermap;
import net.sourceforge.pmd.lang.ast.internal.StreamImpl;
import net.sourceforge.pmd.lang.ast.internal.TreeWalker;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.IteratorUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class IteratorBasedNStream<T extends Node>
implements NodeStream<T> {
    IteratorBasedNStream() {
    }

    @Override
    public abstract Iterator<T> iterator();

    @Override
    public Spliterator<T> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 16);
    }

    @Override
    public Stream<T> toStream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public <R extends Node> NodeStream<R> flatMap(Function<? super T, ? extends @Nullable NodeStream<? extends R>> mapper) {
        Function mapped = mapper.andThen(IteratorBasedNStream::safeMap);
        return this.mapIter(iter -> IteratorUtil.flatMap(iter, mapped));
    }

    private static <R extends Node> @NonNull Iterator<? extends R> safeMap(@Nullable NodeStream<? extends R> ns) {
        return ns == null ? Collections.emptyIterator() : ns.iterator();
    }

    @Override
    public <R extends Node> NodeStream<@NonNull R> map(Function<? super T, ? extends @Nullable R> mapper) {
        return this.mapIter(iter -> IteratorUtil.mapNotNull(iter, mapper));
    }

    @Override
    public NodeStream<T> filter(Predicate<? super @NonNull T> predicate) {
        return this.mapIter(it -> IteratorUtil.mapNotNull(it, Filtermap.filter(predicate)));
    }

    @Override
    public <R extends Node> NodeStream<R> filterIs(Class<? extends R> rClass) {
        return this.mapIter(it -> IteratorUtil.mapNotNull(it, Filtermap.isInstance(rClass)));
    }

    @Override
    public NodeStream.DescendantNodeStream<Node> descendants() {
        return this.flatMapDescendants(Node::descendants);
    }

    @Override
    public NodeStream.DescendantNodeStream<Node> descendantsOrSelf() {
        return this.flatMapDescendants(Node::descendantsOrSelf);
    }

    @Override
    public <R extends Node> NodeStream.DescendantNodeStream<R> descendants(Class<? extends R> rClass) {
        return this.flatMapDescendants(node -> node.descendants(rClass));
    }

    protected <R extends Node> @NonNull NodeStream.DescendantNodeStream<R> flatMapDescendants(Function<T, NodeStream.DescendantNodeStream<? extends R>> mapper) {
        return new DescendantMapping<T, R>(this, mapper);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.iterator().forEachRemaining(action);
    }

    @Override
    public @Nullable T get(int n) {
        if (n == 0) {
            return this.first();
        }
        return (T)((Node)IteratorUtil.getNth(this.iterator(), n));
    }

    @Override
    public NodeStream<T> drop(int n) {
        AssertionUtil.requireNonNegative("n", n);
        return n == 0 ? this : this.mapIter(iter -> IteratorUtil.drop(iter, n));
    }

    @Override
    public NodeStream<T> take(int maxSize) {
        AssertionUtil.requireNonNegative("maxSize", maxSize);
        return maxSize == 0 ? NodeStream.empty() : this.mapIter(iter -> IteratorUtil.take(iter, maxSize));
    }

    @Override
    public NodeStream<T> dropLast(int n) {
        AssertionUtil.requireNonNegative("n", n);
        return n == 0 ? this : this.mapIter(iter -> IteratorUtil.dropLast(iter, n));
    }

    @Override
    public NodeStream<T> takeWhile(Predicate<? super T> predicate) {
        return this.mapIter(iter -> IteratorUtil.takeWhile(iter, predicate));
    }

    @Override
    public final <R, A> R collect(Collector<? super T, A, R> collector) {
        Object container = collector.supplier().get();
        BiConsumer accumulator = collector.accumulator();
        this.forEach(u -> accumulator.accept(container, (Object)u));
        return CollectionUtil.finish(collector, container);
    }

    @Override
    public NodeStream<T> distinct() {
        return this.mapIter(IteratorUtil::distinct);
    }

    @Override
    public NodeStream<T> peek(Consumer<? super T> action) {
        return this.mapIter(iter -> IteratorUtil.peek(iter, action));
    }

    @Override
    public NodeStream<T> append(NodeStream<? extends T> right) {
        return this.mapIter(iter -> IteratorUtil.concat(iter, right.iterator()));
    }

    @Override
    public NodeStream<T> prepend(NodeStream<? extends T> right) {
        return this.mapIter(iter -> IteratorUtil.concat(right.iterator(), iter));
    }

    @Override
    public boolean any(Predicate<? super T> predicate) {
        return IteratorUtil.anyMatch(this.iterator(), predicate);
    }

    @Override
    public boolean none(Predicate<? super T> predicate) {
        return IteratorUtil.noneMatch(this.iterator(), predicate);
    }

    @Override
    public boolean all(Predicate<? super T> predicate) {
        return IteratorUtil.allMatch(this.iterator(), predicate);
    }

    @Override
    public int count() {
        return IteratorUtil.count(this.iterator());
    }

    @Override
    public boolean nonEmpty() {
        return this.iterator().hasNext();
    }

    @Override
    public @Nullable T first() {
        Iterator<T> iter = this.iterator();
        return (T)(iter.hasNext() ? (Node)iter.next() : null);
    }

    @Override
    public @Nullable T last() {
        return (T)((Node)IteratorUtil.last(this.iterator()));
    }

    @Override
    public List<T> toList() {
        return IteratorUtil.toList(this.iterator());
    }

    @Override
    public <R extends Node> @Nullable R first(Class<? extends R> r1Class) {
        for (Node t : this) {
            if (!r1Class.isInstance(t)) continue;
            return (R)((Node)r1Class.cast(t));
        }
        return null;
    }

    @Override
    public @Nullable T first(Predicate<? super T> predicate) {
        for (Node t : this) {
            if (!predicate.test(t)) continue;
            return (T)t;
        }
        return null;
    }

    @Override
    public NodeStream<T> cached() {
        return StreamImpl.fromNonNullList(this.toList());
    }

    protected <R extends Node> NodeStream<R> mapIter(Function<Iterator<T>, Iterator<R>> fun) {
        return new IteratorMapping(fun);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.toStream().map(Objects::toString).collect(Collectors.joining(", ")) + "]";
    }

    private static class DescendantMapping<T extends Node, S extends Node>
    extends IteratorBasedNStream<S>
    implements NodeStream.DescendantNodeStream<S> {
        private final Function<? super T, ? extends NodeStream.DescendantNodeStream<? extends S>> fun;
        private final TreeWalker walker;
        private final IteratorBasedNStream<T> upstream;

        private DescendantMapping(IteratorBasedNStream<T> upstream, Function<? super T, ? extends NodeStream.DescendantNodeStream<? extends S>> fun, TreeWalker walker) {
            this.fun = fun;
            this.walker = walker;
            this.upstream = upstream;
        }

        DescendantMapping(IteratorBasedNStream<T> upstream, Function<? super T, ? extends NodeStream.DescendantNodeStream<? extends S>> fun) {
            this(upstream, fun, TreeWalker.DEFAULT);
        }

        @Override
        public Iterator<S> iterator() {
            return IteratorUtil.flatMap(this.upstream.iterator(), t -> {
                NodeStream.DescendantNodeStream<? extends S> app = this.fun.apply((Node)t);
                return this.walker.apply(app).iterator();
            });
        }

        @Override
        public NodeStream.DescendantNodeStream<S> crossFindBoundaries(boolean cross) {
            return this.walker.isCrossFindBoundaries() == cross ? this : new DescendantMapping<T, S>(this.upstream, this.fun, this.walker.crossFindBoundaries(cross));
        }
    }

    private final class IteratorMapping<S extends Node>
    extends IteratorBasedNStream<S> {
        private final Function<Iterator<T>, Iterator<S>> fun;

        private IteratorMapping(Function<Iterator<T>, Iterator<S>> fun) {
            this.fun = fun;
        }

        @Override
        public Iterator<S> iterator() {
            return this.fun.apply(IteratorBasedNStream.this.iterator());
        }
    }
}

