/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.util.Comparator;
import java.util.Objects;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextPos2d;
import net.sourceforge.pmd.lang.document.TextRange2d;
import net.sourceforge.pmd.lang.document.TextRegion;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FileLocation {
    public static final Comparator<FileLocation> COORDS_COMPARATOR = Comparator.comparing(FileLocation::getStartPos).thenComparing(FileLocation::getEndPos);
    public static final Comparator<FileLocation> COMPARATOR = Comparator.comparing(FileLocation::getFileId).thenComparing(COORDS_COMPARATOR);
    private final int beginLine;
    private final int endLine;
    private final int beginColumn;
    private final int endColumn;
    private final FileId fileName;
    private final @Nullable TextRegion region;

    FileLocation(FileId fileName, int beginLine, int beginColumn, int endLine, int endColumn) {
        this(fileName, beginLine, beginColumn, endLine, endColumn, null);
    }

    FileLocation(FileId fileName, int beginLine, int beginColumn, int endLine, int endColumn, @Nullable TextRegion region) {
        this.fileName = Objects.requireNonNull(fileName);
        this.beginLine = AssertionUtil.requireOver1("Begin line", beginLine);
        this.endLine = AssertionUtil.requireOver1("End line", endLine);
        this.beginColumn = AssertionUtil.requireOver1("Begin column", beginColumn);
        this.endColumn = AssertionUtil.requireOver1("End column", endColumn);
        this.region = region;
        this.requireLinesCorrectlyOrdered();
    }

    private void requireLinesCorrectlyOrdered() {
        if (this.beginLine > this.endLine) {
            throw AssertionUtil.mustBe("endLine", this.endLine, ">= beginLine (= " + this.beginLine + ")");
        }
        if (this.beginLine == this.endLine && this.beginColumn > this.endColumn) {
            throw AssertionUtil.mustBe("endColumn", this.endColumn, ">= beginColumn (= " + this.beginColumn + ")");
        }
    }

    public FileId getFileId() {
        return this.fileName;
    }

    public int getStartLine() {
        return this.beginLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getStartColumn() {
        return this.beginColumn;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public TextPos2d getStartPos() {
        return TextPos2d.pos2d(this.beginLine, this.beginColumn);
    }

    public TextPos2d getEndPos() {
        return TextPos2d.pos2d(this.endLine, this.endColumn);
    }

    public TextRange2d toRange2d() {
        return TextRange2d.range2d(this.beginLine, this.beginColumn, this.endLine, this.endColumn);
    }

    public @Nullable TextRegion getRegionInFile() {
        return this.region;
    }

    public String startPosToString() {
        return this.getStartPos().toDisplayStringInEnglish();
    }

    public String startPosToStringWithFile() {
        return this.getFileId().getOriginalPath() + ":" + this.getStartPos().toDisplayStringWithColon();
    }

    public int getLineCount() {
        return this.getEndLine() - this.getStartLine() + 1;
    }

    public static FileLocation range(FileId fileName, TextRange2d range2d) {
        TextPos2d start = range2d.getStartPos();
        TextPos2d end = range2d.getEndPos();
        return new FileLocation(fileName, start.getLine(), start.getColumn(), end.getLine(), end.getColumn());
    }

    public static FileLocation caret(FileId fileName, int line, int column) {
        return new FileLocation(fileName, line, column, line, column);
    }

    public String toString() {
        return "!debug only! " + this.startPosToStringWithFile();
    }
}

