/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.BaseMappedDocument;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.TextDocument;
import org.checkerframework.checker.nullness.qual.Nullable;

final class FragmentedTextDocument
extends BaseMappedDocument
implements TextDocument {
    private final Chars text;
    private Fragment lastAccessedFragment;

    FragmentedTextDocument(TextDocument base, Fragment firstFragment, Fragment lastFragment) {
        super(base);
        assert (firstFragment != lastFragment);
        this.text = FragmentedTextDocument.toChars(firstFragment, lastFragment);
        this.lastAccessedFragment = firstFragment;
    }

    private static Chars toChars(Fragment firstFragment, Fragment lastFragment) {
        StringBuilder sb = new StringBuilder(lastFragment.outEnd());
        Fragment f = firstFragment;
        while (f != null) {
            f.getChars().appendChars(sb);
            f = f.next;
        }
        return Chars.wrap(sb);
    }

    @Override
    public Chars getText() {
        return this.text;
    }

    @Override
    public LanguageVersion getLanguageVersion() {
        return this.base.getLanguageVersion();
    }

    @Override
    protected int localOffsetTransform(int outOffset, boolean inclusive) {
        boolean containsOffset;
        Fragment f = this.lastAccessedFragment;
        if (f == null) {
            return outOffset;
        }
        boolean bl = containsOffset = f.outStart() <= outOffset && outOffset < f.outEnd();
        if (!containsOffset) {
            if (f.outEnd() < outOffset) {
                while (f.next != null && f.outEnd() < outOffset) {
                    f = f.next;
                }
            } else {
                while (f.prev != null && outOffset <= f.outStart()) {
                    f = f.prev;
                }
            }
            this.lastAccessedFragment = f;
        }
        if (inclusive && f.outEnd() == outOffset && f.next != null) {
            do {
                f = f.next;
            } while (f.next != null && f.outLen() == 0);
        }
        return f.outToIn(outOffset);
    }

    static final class Fragment {
        private final Chars chars;
        final @Nullable Fragment prev;
        @Nullable Fragment next;
        private final int inStart;
        private final int inLength;
        private final int outStart;

        Fragment(@Nullable Fragment prev, int inLength, Chars chars) {
            this.chars = chars;
            this.prev = prev;
            this.inLength = inLength;
            if (prev != null) {
                prev.next = this;
                this.outStart = prev.outEnd();
                this.inStart = prev.inEnd();
            } else {
                this.outStart = 0;
                this.inStart = 0;
            }
        }

        public Chars getChars() {
            return this.chars;
        }

        int outStart() {
            return this.outStart;
        }

        int outLen() {
            return this.chars.length();
        }

        int outEnd() {
            return this.outStart() + this.outLen();
        }

        int inStart() {
            return this.inStart;
        }

        int inLen() {
            return this.inLength;
        }

        int inEnd() {
            return this.inStart() + this.inLen();
        }

        int outToIn(int outOffset) {
            return this.inStart() + outOffset - this.outStart();
        }

        int inToOut(int inOffset) {
            return inOffset - this.inStart() + this.outStart();
        }

        public String toString() {
            return "Fragment[" + this.inStart() + ".." + this.inEnd() + " -> " + this.outStart() + ".." + this.outEnd() + "]" + this.chars;
        }
    }
}

