/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.io.IOException;
import java.util.Objects;
import net.sourceforge.pmd.internal.util.BaseCloseable;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.SourceCodePositioner;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.document.TextFileContent;
import net.sourceforge.pmd.lang.document.TextPos2d;
import net.sourceforge.pmd.lang.document.TextRegion;

final class RootTextDocument
extends BaseCloseable
implements TextDocument {
    private final TextFile backend;
    private final TextFileContent content;
    private final LanguageVersion langVersion;
    private final FileId fileId;
    private static final String NOT_IN_RANGE = "Region [start=%d, end=%d[ is not in range of this document (length %d)";
    private static final String INVALID_LINE_RANGE = "Line range %d..%d is not in range of this document (%d lines) (line numbers are 1-based)";
    private static final String INVALID_OFFSET = "Offset %d is not in range of this document (length %d) (offsets are 0-based)";

    RootTextDocument(TextFile backend) throws IOException {
        this.backend = backend;
        this.content = backend.readContents();
        this.langVersion = backend.getLanguageVersion();
        this.fileId = backend.getFileId();
        Objects.requireNonNull(this.langVersion, "Null language version for file " + backend);
        Objects.requireNonNull(this.fileId, "Null path id for file " + backend);
    }

    @Override
    public LanguageVersion getLanguageVersion() {
        return this.langVersion;
    }

    @Override
    public FileId getFileId() {
        return this.fileId;
    }

    @Override
    protected void doClose() throws IOException {
        this.backend.close();
    }

    @Override
    public Chars getText() {
        return this.content.getNormalizedText();
    }

    @Override
    public FileLocation toLocation(TextRegion region) {
        RootTextDocument.checkInRange(region, this.getLength());
        SourceCodePositioner positioner = this.content.getPositioner();
        TextPos2d bpos = positioner.lineColFromOffset(region.getStartOffset(), true);
        TextPos2d epos = region.isEmpty() ? bpos : positioner.lineColFromOffset(region.getEndOffset(), false);
        return new FileLocation(this.fileId, bpos.getLine(), bpos.getColumn(), epos.getLine(), epos.getColumn(), region);
    }

    @Override
    public TextPos2d lineColumnAtOffset(int offset, boolean inclusive) {
        return this.content.getPositioner().lineColFromOffset(offset, inclusive);
    }

    @Override
    public int offsetAtLineColumn(TextPos2d position) {
        return this.content.getPositioner().offsetFromLineColumn(position.getLine(), position.getColumn());
    }

    @Override
    public TextRegion createLineRange(int startLineInclusive, int endLineInclusive) {
        SourceCodePositioner positioner = this.content.getPositioner();
        if (!positioner.isValidLine(startLineInclusive) || !positioner.isValidLine(endLineInclusive) || startLineInclusive > endLineInclusive) {
            throw RootTextDocument.invalidLineRange(startLineInclusive, endLineInclusive, positioner.getLastLine());
        }
        int first = positioner.offsetFromLineColumn(startLineInclusive, 1);
        int last = positioner.offsetOfEndOfLine(endLineInclusive);
        return TextRegion.fromBothOffsets(first, last);
    }

    static void checkInRange(TextRegion region, int length) {
        if (region.getEndOffset() > length) {
            throw RootTextDocument.regionOutOfBounds(region.getStartOffset(), region.getEndOffset(), length);
        }
    }

    @Override
    public long getCheckSum() {
        return this.content.getCheckSum();
    }

    @Override
    public Chars sliceOriginalText(TextRegion region) {
        return this.getText().subSequence(region.getStartOffset(), region.getEndOffset());
    }

    static IndexOutOfBoundsException invalidLineRange(int start, int end, int numLines) {
        return new IndexOutOfBoundsException(String.format(INVALID_LINE_RANGE, start, end, numLines));
    }

    static IndexOutOfBoundsException regionOutOfBounds(int start, int end, int maxLen) {
        return new IndexOutOfBoundsException(String.format(NOT_IN_RANGE, start, end, maxLen));
    }

    static IndexOutOfBoundsException invalidOffset(int offset, int maxLen) {
        return new IndexOutOfBoundsException(String.format(INVALID_OFFSET, offset, maxLen));
    }
}

