/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.RootTextDocument;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.document.TextPos2d;
import net.sourceforge.pmd.lang.document.TextRegion;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface TextDocument
extends Closeable {
    public LanguageVersion getLanguageVersion();

    public FileId getFileId();

    public Chars getText();

    public Chars sliceOriginalText(TextRegion var1);

    default public Chars sliceTranslatedText(TextRegion region) {
        return this.getText().slice(region);
    }

    public long getCheckSum();

    default public Reader newReader() {
        return this.getText().newReader();
    }

    default public int getLength() {
        return this.getText().length();
    }

    default public TextRegion getEntireRegion() {
        return TextRegion.fromOffsetLength(0, this.getLength());
    }

    public TextRegion createLineRange(int var1, int var2);

    public FileLocation toLocation(TextRegion var1);

    default public TextPos2d lineColumnAtOffset(int offset) {
        return this.lineColumnAtOffset(offset, true);
    }

    public TextPos2d lineColumnAtOffset(int var1, boolean var2);

    public int offsetAtLineColumn(TextPos2d var1);

    @Override
    public void close() throws IOException;

    public static TextDocument create(TextFile textFile) throws IOException {
        return new RootTextDocument(textFile);
    }

    public static TextDocument readOnlyString(CharSequence source, LanguageVersion lv) {
        return TextDocument.readOnlyString(source, FileId.UNKNOWN, lv);
    }

    public static TextDocument readOnlyString(@NonNull CharSequence source, @NonNull FileId filename, @NonNull LanguageVersion lv) {
        TextFile textFile = TextFile.forCharSeq(source, filename, lv);
        try {
            return TextDocument.create(textFile);
        }
        catch (IOException e) {
            throw new AssertionError("String text file should never throw IOException", e);
        }
    }
}

