/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.internal;

import java.util.Collection;
import java.util.Iterator;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimedOperation;
import net.sourceforge.pmd.benchmark.TimedOperationCategory;
import net.sourceforge.pmd.internal.SystemProps;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.rule.InternalApiBridge;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.internal.TargetSelectorInternal;
import net.sourceforge.pmd.lang.rule.internal.TreeIndex;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleApplicator {
    private static final Logger LOG = LoggerFactory.getLogger(RuleApplicator.class);
    private final TreeIndex idx;
    private LanguageVersion currentLangVer;

    public RuleApplicator(TreeIndex index) {
        this.idx = index;
    }

    public void index(RootNode root) {
        this.idx.reset();
        this.indexTree(root, this.idx);
        this.currentLangVer = root.getLanguageVersion();
    }

    public void apply(Collection<? extends Rule> rules, FileAnalysisListener listener) {
        this.applyOnIndex(this.idx, rules, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyOnIndex(TreeIndex idx, Collection<? extends Rule> rules, FileAnalysisListener listener) {
        for (Rule rule : rules) {
            if (!InternalApiBridge.ruleSetApplies(rule, this.currentLangVer)) continue;
            RuleContext ctx = net.sourceforge.pmd.reporting.InternalApiBridge.createRuleContext(listener, rule);
            rule.start(ctx);
            try {
                TimedOperation rcto = TimeTracker.startOperation(TimedOperationCategory.RULE, rule.getName());
                try {
                    int nodeCounter = 0;
                    Iterator<? extends Node> targets = rule.getTargetSelector().getVisitedNodes(idx);
                    while (targets.hasNext()) {
                        Node node = targets.next();
                        try {
                            ++nodeCounter;
                            rule.apply(node, ctx);
                        }
                        catch (RuntimeException e) {
                            this.reportOrRethrow(listener, rule, node, AssertionUtil.contexted(e), true);
                        }
                        catch (StackOverflowError e) {
                            this.reportOrRethrow(listener, rule, node, AssertionUtil.contexted(e), SystemProps.isErrorRecoveryMode());
                        }
                        catch (AssertionError e) {
                            this.reportOrRethrow(listener, rule, node, AssertionUtil.contexted(e), SystemProps.isErrorRecoveryMode());
                        }
                    }
                    rcto.close(nodeCounter);
                }
                finally {
                    if (rcto == null) continue;
                    rcto.close();
                }
            }
            finally {
                rule.end(ctx);
            }
        }
    }

    private <E extends Throwable> void reportOrRethrow(FileAnalysisListener listener, Rule rule, Node node, E e, boolean reportAndDontThrow) throws E {
        if (e instanceof ExceptionContext) {
            ((ExceptionContext)e).addContextValue("Rule applied on node", (Object)node);
        }
        if (!reportAndDontThrow) {
            throw e;
        }
        this.reportException(listener, rule, node, e);
    }

    private void reportException(FileAnalysisListener listener, Rule rule, Node node, Throwable e) {
        listener.onError(new Report.ProcessingError(e, node.getTextDocument().getFileId()));
        LOG.warn("Exception applying rule {} on file {}, continuing with next rule", new Object[]{rule.getName(), node.getTextDocument().getFileId().getAbsolutePath(), e});
        String nodeToString = StringUtil.elide(node.toString(), 600, " ... (truncated)");
        LOG.warn("Exception occurred on node {}", (Object)nodeToString);
    }

    private void indexTree(Node top, TreeIndex idx) {
        idx.indexNode(top);
        for (Node node : top.children()) {
            this.indexTree(node, idx);
        }
    }

    public static RuleApplicator build(Iterable<? extends Rule> rules) {
        TargetSelectorInternal.ApplicatorBuilder builder = new TargetSelectorInternal.ApplicatorBuilder();
        for (Rule rule : rules) {
            rule.getTargetSelector().prepare(builder);
        }
        return builder.build();
    }
}

