/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath.impl;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.impl.AbstractNode;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.rule.xpath.Attribute;
import net.sourceforge.pmd.lang.rule.xpath.NoAttribute;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AttributeAxisIterator
implements Iterator<Attribute> {
    private static final ConcurrentMap<Class<?>, List<MethodWrapper>> METHOD_CACHE = new ConcurrentHashMap();
    private static final Set<Class<?>> CONSIDERED_RETURN_TYPES = CollectionUtil.setOf(Integer.TYPE, Boolean.TYPE, Double.TYPE, String.class, Long.TYPE, Character.TYPE, Float.TYPE, Chars.class);
    private static final Set<String> FILTERED_OUT_NAMES = CollectionUtil.setOf("toString", "getNumChildren", "getIndexInParent", "getParent", "getClass", "getSourceCodeFile", "isFindBoundary", "getRuleIndex", "getXPathNodeName", "altNumber", "toStringTree", "getTypeNameNode", "hashCode", "getImportedNameNode", "getScope");
    private final Iterator<MethodWrapper> iterator;
    private final Node node;

    public AttributeAxisIterator(@NonNull Node contextNode) {
        this.node = contextNode;
        this.iterator = METHOD_CACHE.computeIfAbsent(contextNode.getClass(), this::getWrappersForClass).iterator();
    }

    private List<MethodWrapper> getWrappersForClass(Class<?> nodeClass) {
        return Arrays.stream(nodeClass.getMethods()).filter(m -> this.isAttributeAccessor(nodeClass, (Method)m)).map(m -> {
            try {
                return new MethodWrapper((Method)m);
            }
            catch (ReflectiveOperationException e) {
                throw AssertionUtil.shouldNotReachHere("Method '" + m + "' should be accessible, but: " + e, e);
            }
        }).collect(Collectors.toList());
    }

    protected boolean isAttributeAccessor(Class<?> nodeClass, Method method) {
        String methodName = method.getName();
        return !methodName.startsWith("jjt") && !FILTERED_OUT_NAMES.contains(methodName) && method.getParameterTypes().length == 0 && this.isConsideredReturnType(method) && Node.class.isAssignableFrom(method.getDeclaringClass()) && Modifier.isPublic(method.getModifiers()) && !this.isIgnored(nodeClass, method);
    }

    private boolean isConsideredReturnType(Method method) {
        Type t;
        Class<?> klass = method.getReturnType();
        if (CONSIDERED_RETURN_TYPES.contains(klass) || klass.isEnum()) {
            return true;
        }
        if (Collection.class.isAssignableFrom(klass) && (t = method.getGenericReturnType()) instanceof ParameterizedType) {
            try {
                Type actualTypeArgument = ((ParameterizedType)t).getActualTypeArguments()[0];
                if (!TypeVariable.class.isAssignableFrom(actualTypeArgument.getClass())) {
                    Class<?> elementKlass = Class.forName(actualTypeArgument.getTypeName());
                    return CONSIDERED_RETURN_TYPES.contains(elementKlass) || elementKlass.isEnum();
                }
            }
            catch (ClassNotFoundException e) {
                throw AssertionUtil.shouldNotReachHere("Method '" + method + "' should return a known type, but: " + e, e);
            }
        }
        return false;
    }

    private boolean isIgnored(Class<?> nodeClass, Method method) {
        Class<?> declaration = method.getDeclaringClass();
        if (method.isAnnotationPresent(NoAttribute.class)) {
            return true;
        }
        if (declaration == Node.class || declaration == AbstractNode.class) {
            return false;
        }
        NoAttribute declAnnot = declaration.getAnnotation(NoAttribute.class);
        if (declAnnot != null && declAnnot.scope() == NoAttribute.NoAttrScope.ALL) {
            return true;
        }
        NoAttribute localAnnot = nodeClass.getAnnotation(NoAttribute.class);
        if (localAnnot == null) {
            return false;
        }
        if (!declaration.equals(nodeClass) || method.isBridge()) {
            return localAnnot.scope() == NoAttribute.NoAttrScope.INHERITED;
        }
        return localAnnot.scope() == NoAttribute.NoAttrScope.ALL;
    }

    @Override
    public Attribute next() {
        MethodWrapper m = this.iterator.next();
        return new Attribute(this.node, m.name, m.methodHandle, m.method);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    private static class MethodWrapper {
        static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();
        private static final MethodType GETTER_TYPE = MethodType.methodType(Object.class, Node.class);
        public final MethodHandle methodHandle;
        public final Method method;
        public final String name;

        MethodWrapper(Method m) throws IllegalAccessException {
            this.method = m;
            this.name = this.truncateMethodName(m.getName());
            this.methodHandle = LOOKUP.unreflect(m).asType(GETTER_TYPE);
        }

        private String truncateMethodName(String n) {
            if (n.startsWith("get")) {
                return n.substring("get".length());
            }
            if (n.startsWith("is")) {
                return n.substring("is".length());
            }
            if (n.startsWith("has")) {
                return n.substring("has".length());
            }
            if (n.startsWith("uses")) {
                return n.substring("uses".length());
            }
            if ("size".equals(n)) {
                return "Size";
            }
            if ("length".equals(n)) {
                return "Length";
            }
            return n;
        }
    }
}

