/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertySource;

public abstract class AbstractPropertySource
implements PropertySource {
    private final List<PropertyDescriptor<?>> propertyDescriptors = new ArrayList();
    private final Map<PropertyDescriptor<?>, Object> propertyValuesByDescriptor = new HashMap();

    @Override
    public void definePropertyDescriptor(PropertyDescriptor<?> propertyDescriptor) {
        if (this.getPropertyDescriptor(propertyDescriptor.name()) != null) {
            throw new IllegalArgumentException("There is already a PropertyDescriptor with name '" + propertyDescriptor.name() + "' defined on " + this.getPropertySourceType() + " " + this.getName() + ".");
        }
        this.propertyDescriptors.add(propertyDescriptor);
    }

    protected abstract String getPropertySourceType();

    @Override
    public PropertyDescriptor<?> getPropertyDescriptor(String name) {
        for (PropertyDescriptor<?> propertyDescriptor : this.propertyDescriptors) {
            if (!name.equals(propertyDescriptor.name())) continue;
            return propertyDescriptor;
        }
        return null;
    }

    @Override
    public boolean hasDescriptor(PropertyDescriptor<?> descriptor) {
        return this.propertyDescriptors.contains(descriptor);
    }

    @Override
    public final List<PropertyDescriptor<?>> getOverriddenPropertyDescriptors() {
        return new ArrayList(this.propertyValuesByDescriptor.keySet());
    }

    @Override
    public List<PropertyDescriptor<?>> getPropertyDescriptors() {
        return Collections.unmodifiableList(this.propertyDescriptors);
    }

    @Override
    public <T> T getProperty(PropertyDescriptor<T> propertyDescriptor) {
        this.checkValidPropertyDescriptor(propertyDescriptor);
        Object result = propertyDescriptor.defaultValue();
        if (this.propertyValuesByDescriptor.containsKey(propertyDescriptor)) {
            Object value = this.propertyValuesByDescriptor.get(propertyDescriptor);
            result = value;
        }
        return result;
    }

    @Override
    public boolean isPropertyOverridden(PropertyDescriptor<?> propertyDescriptor) {
        return this.propertyValuesByDescriptor.containsKey(propertyDescriptor);
    }

    @Override
    public <T> void setProperty(PropertyDescriptor<T> propertyDescriptor, T value) {
        this.checkValidPropertyDescriptor(propertyDescriptor);
        if (value instanceof List) {
            this.propertyValuesByDescriptor.put(propertyDescriptor, Collections.unmodifiableList((List)value));
        } else {
            this.propertyValuesByDescriptor.put(propertyDescriptor, value);
        }
    }

    private void checkValidPropertyDescriptor(PropertyDescriptor<?> propertyDescriptor) {
        if (!this.hasDescriptor(propertyDescriptor)) {
            throw new IllegalArgumentException("Property descriptor not defined for " + this.getPropertySourceType() + " " + this.getName() + ": " + propertyDescriptor);
        }
    }

    @Override
    public final Map<PropertyDescriptor<?>, Object> getOverriddenPropertiesByPropertyDescriptor() {
        return new HashMap(this.propertyValuesByDescriptor);
    }

    @Override
    public Map<PropertyDescriptor<?>, Object> getPropertiesByPropertyDescriptor() {
        if (this.propertyDescriptors.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap propertiesByPropertyDescriptor = new HashMap(this.propertyDescriptors.size());
        propertiesByPropertyDescriptor.putAll(this.propertyValuesByDescriptor);
        for (PropertyDescriptor<?> propertyDescriptor : this.propertyDescriptors) {
            if (propertiesByPropertyDescriptor.containsKey(propertyDescriptor)) continue;
            propertiesByPropertyDescriptor.put(propertyDescriptor, propertyDescriptor.defaultValue());
        }
        return Collections.unmodifiableMap(propertiesByPropertyDescriptor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPropertySource that = (AbstractPropertySource)o;
        if (!Objects.equals(this.propertyDescriptors, that.propertyDescriptors)) {
            return false;
        }
        HashMap propertiesWithValues = new HashMap();
        this.propertyDescriptors.forEach(propertyDescriptor -> {
            Object value = this.propertyValuesByDescriptor.getOrDefault(propertyDescriptor, propertyDescriptor.defaultValue());
            String valueString = propertyDescriptor.serializer().toString(value);
            propertiesWithValues.put(propertyDescriptor.name(), valueString);
        });
        HashMap thatPropertiesWithValues = new HashMap();
        that.propertyDescriptors.forEach(propertyDescriptor -> {
            Object value = that.propertyValuesByDescriptor.getOrDefault(propertyDescriptor, propertyDescriptor.defaultValue());
            String valueString = propertyDescriptor.serializer().toString(value);
            thatPropertiesWithValues.put(propertyDescriptor.name(), valueString);
        });
        return Objects.equals(propertiesWithValues, thatPropertiesWithValues);
    }

    public int hashCode() {
        return Objects.hash(this.propertyDescriptors, this.propertyValuesByDescriptor);
    }
}

