/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties.internal;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.sourceforge.pmd.internal.util.PredicateUtil;
import net.sourceforge.pmd.properties.InternalApiBridge;
import net.sourceforge.pmd.properties.PropertyConstraint;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

class ValueSyntax<T>
extends InternalApiBridge.InternalPropertySerializer<T> {
    private final Function<? super T, @NonNull String> toString;
    private final Function<@NonNull String, ? extends T> fromString;
    private final List<PropertyConstraint<? super T>> docConstraints;

    ValueSyntax(Function<? super T, String> toString, Function<@NonNull String, ? extends T> fromString, List<PropertyConstraint<? super T>> docConstraints) {
        this.toString = toString;
        this.fromString = fromString;
        this.docConstraints = docConstraints;
    }

    @Override
    public List<PropertyConstraint<? super T>> getConstraints() {
        return this.docConstraints;
    }

    @Override
    public T fromString(@NonNull String attributeData) {
        return this.fromString.apply(attributeData);
    }

    @Override
    public @NonNull String toString(T data) {
        return this.toString.apply(data);
    }

    static <T> ValueSyntax<T> partialFunction(Function<? super T, @NonNull String> toString, Function<@NonNull String, ? extends T> fromString, PropertyConstraint<? super @NonNull String> checker) {
        PropertyConstraint docConstraint = PropertyConstraint.fromPredicate(PredicateUtil.always(), checker.getConstraintDescription());
        return new ValueSyntax<T>(toString, s -> {
            checker.validate((String)s);
            return fromString.apply((String)s);
        }, CollectionUtil.listOf(docConstraint, new PropertyConstraint[0]));
    }

    static <T> ValueSyntax<T> withDefaultToString(Function<String, ? extends T> fromString) {
        return new ValueSyntax<T>(Objects::toString, fromString, Collections.emptyList());
    }

    static <T> ValueSyntax<T> create(Function<? super T, String> toString, Function<String, ? extends T> fromString) {
        return new ValueSyntax<T>(toString, fromString, Collections.emptyList());
    }
}

