/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.internal.xml;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.internal.xml.PmdXmlReporter;
import net.sourceforge.pmd.util.internal.xml.XmlUtil;
import net.sourceforge.pmd.util.log.PmdReporter;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SchemaConstant {
    private final String name;

    public SchemaConstant(String name) {
        this.name = name;
    }

    public boolean getAsBooleanAttr(Element e, boolean defaultValue) {
        String attr = e.getAttribute(this.name);
        return e.hasAttribute(this.name) ? Boolean.parseBoolean(attr) : defaultValue;
    }

    public @NonNull String getAttributeOrThrow(Element element, PmdXmlReporter err) {
        String attribute = element.getAttribute(this.name);
        if (!element.hasAttribute(this.name)) {
            throw ((PmdReporter)err.at(element)).error("Required attribute ''{0}'' is missing", this.name);
        }
        return attribute;
    }

    public @NonNull String getNonBlankAttributeOrThrow(Element element, PmdXmlReporter err) {
        String attribute = element.getAttribute(this.name);
        if (!element.hasAttribute(this.name)) {
            throw ((PmdReporter)err.at(element)).error("Required attribute ''{0}'' is missing", this.name);
        }
        if (StringUtils.isBlank((CharSequence)attribute)) {
            throw ((PmdReporter)err.at(element)).error("Required attribute ''{0}'' is blank", this.name);
        }
        return attribute;
    }

    public @Nullable String getAttributeOrNull(Element element) {
        if (element.hasAttribute(this.name)) {
            return element.getAttribute(this.name);
        }
        return null;
    }

    public Optional<String> getAttributeOpt(Element element) {
        Attr attr = element.getAttributeNode(this.name);
        return Optional.ofNullable(attr).map(Attr::getValue);
    }

    public @Nullable Attr getAttributeNode(Element element) {
        return element.getAttributeNode(this.name);
    }

    public boolean hasAttribute(Element element) {
        return element.hasAttribute(this.name);
    }

    public List<Element> getChildrenIn(Element elt) {
        return XmlUtil.getElementChildrenNamed(elt, this.name).collect(Collectors.toList());
    }

    public List<Element> getElementChildrenNamedReportOthers(Element elt, PmdXmlReporter err) {
        return XmlUtil.getElementChildrenNamedReportOthers(elt, CollectionUtil.setOf(this, new SchemaConstant[0]), err).collect(Collectors.toList());
    }

    public @NonNull Element getSingleChildIn(Element elt, PmdXmlReporter err) {
        return XmlUtil.getSingleChildIn(elt, true, err, CollectionUtil.setOf(this, new SchemaConstant[0]));
    }

    public @Nullable Element getOptChildIn(Element elt, PmdXmlReporter err) {
        return XmlUtil.getSingleChildIn(elt, false, err, CollectionUtil.setOf(this, new SchemaConstant[0]));
    }

    public void setOn(Element element, String value) {
        element.setAttribute(this.name, value);
    }

    public String xmlName() {
        return this.name;
    }

    public String toString() {
        return this.xmlName();
    }

    public boolean matchesElt(Node node) {
        return node.getNodeType() == 1 && node.getNodeName().equals(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaConstant that = (SchemaConstant)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public @NonNull String getNonBlankAttribute(Element ruleElement, PmdXmlReporter err) {
        String clazz = this.getAttributeOrThrow(ruleElement, err);
        if (StringUtils.isBlank((CharSequence)clazz)) {
            Attr node = this.getAttributeNode(ruleElement);
            throw ((PmdReporter)err.at(node)).error("Attribute {0} may not be blank", this);
        }
        return clazz;
    }
}

