/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.treeexport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.pmd.internal.Slf4jSimpleConfiguration;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.LanguageProcessorRegistry;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.ast.SemanticErrorReporter;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.rule.xpath.Attribute;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertySource;
import net.sourceforge.pmd.util.treeexport.Io;
import net.sourceforge.pmd.util.treeexport.TreeExportConfiguration;
import net.sourceforge.pmd.util.treeexport.TreeRenderer;
import net.sourceforge.pmd.util.treeexport.TreeRendererDescriptor;
import net.sourceforge.pmd.util.treeexport.TreeRenderers;

public class TreeExporter {
    private final TreeExportConfiguration configuration;
    private final Io io;

    public TreeExporter(TreeExportConfiguration configuration) {
        this(configuration, Io.system());
    }

    TreeExporter(TreeExportConfiguration configuration, Io io) {
        this.configuration = configuration;
        this.io = io;
    }

    public void export() throws IOException {
        TreeRendererDescriptor descriptor = TreeRenderers.findById(this.configuration.getFormat());
        if (descriptor == null) {
            throw this.bail("Unknown format '" + this.configuration.getFormat() + "'");
        }
        PropertySource bundle = this.parseProperties(descriptor.newPropertyBundle(), this.configuration.getProperties());
        LanguagePropertyBundle langProperties = this.parseProperties(this.configuration.getLanguage().newPropertyBundle(), this.configuration.getLanguageProperties());
        LanguageRegistry lang = LanguageRegistry.PMD.getDependenciesOf(this.configuration.getLanguage());
        try (LanguageProcessorRegistry lpRegistry = LanguageProcessorRegistry.create(lang, Collections.singletonMap(this.configuration.getLanguage(), langProperties), this.configuration.getMessageReporter());){
            this.run(lpRegistry, descriptor.produceRenderer(bundle));
        }
    }

    private void run(LanguageProcessorRegistry langRegistry, TreeRenderer renderer) throws IOException {
        TextFile textFile;
        LanguageVersion langVersion = this.configuration.getLanguage().getDefaultVersion();
        LanguageProcessor processor = langRegistry.getProcessor(this.configuration.getLanguage());
        Parser parser = processor.services().getParser();
        if (this.configuration.isReadStdin()) {
            this.io.stderr.println("Reading from stdin...");
            textFile = TextFile.forReader(this.readFromSystemIn(), FileId.STDIN, langVersion);
        } else {
            textFile = TextFile.forPath(this.configuration.getFile(), this.configuration.getSourceEncoding(), langVersion);
        }
        Slf4jSimpleConfiguration.disableLogging(Attribute.class);
        try (TextDocument textDocument = TextDocument.create(textFile);){
            Parser.ParserTask task = new Parser.ParserTask(textDocument, SemanticErrorReporter.noop(), langRegistry);
            RootNode root = parser.parse(task);
            renderer.renderSubtree(root, this.io.stdout);
        }
    }

    private Reader readFromSystemIn() {
        return new BufferedReader(new InputStreamReader(this.io.stdin, Charset.defaultCharset()));
    }

    private <T extends PropertySource> T parseProperties(T bundle, Properties properties) {
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            PropertyDescriptor<?> d = bundle.getPropertyDescriptor(prop.getKey().toString());
            if (d == null) {
                throw this.bail("Unknown property '" + prop.getKey() + "'");
            }
            this.setProperty(d, bundle, prop.getValue().toString());
        }
        return bundle;
    }

    private <T> void setProperty(PropertyDescriptor<T> descriptor, PropertySource bundle, String value) {
        bundle.setProperty(descriptor, descriptor.serializer().fromString(value));
    }

    private AbortedException bail(String message) {
        this.io.stderr.println(message);
        this.io.stderr.println("Use --help for usage information");
        return new AbortedException();
    }

    private static final class AbortedException
    extends RuntimeException {
        private static final long serialVersionUID = -1925142332978792215L;

        private AbortedException() {
        }
    }
}

