/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class CustomImportOrderCheck
extends Check {
    public static final String MSG_LINE_SEPARATOR = "custom.import.order.line.separator";
    public static final String MSG_LEX = "custom.import.order.lex";
    public static final String MSG_NONGROUP_IMPORT = "custom.import.order.nonGroup.import";
    public static final String MSG_NONGROUP_EXPECTED = "custom.import.order.nonGroup.expected";
    public static final String MSG_ORDER = "custom.import.order";
    public static final String STATIC_RULE_GROUP = "STATIC";
    public static final String SAME_PACKAGE_RULE_GROUP = "SAME_PACKAGE";
    public static final String THIRD_PARTY_PACKAGE_RULE_GROUP = "THIRD_PARTY_PACKAGE";
    public static final String STANDARD_JAVA_PACKAGE_RULE_GROUP = "STANDARD_JAVA_PACKAGE";
    public static final String SPECIAL_IMPORTS_RULE_GROUP = "SPECIAL_IMPORTS";
    private static final String NON_GROUP_RULE_GROUP = "NOT_ASSIGNED_TO_ANY_GROUP";
    private static final Pattern GROUP_SEPARATOR_PATTERN = Pattern.compile("\\s*###\\s*");
    private String samePackageDomainsRegExp = "";
    private Pattern standardPackageRegExp = Pattern.compile("^(java|javax)\\.");
    private Pattern thirdPartyPackageRegExp = Pattern.compile(".*");
    private Pattern specialImportsRegExp = Pattern.compile("^$");
    private boolean separateLineBetweenGroups = true;
    private boolean sortImportsInGroupAlphabetically;
    private final List<String> customImportOrderRules = new ArrayList<String>();
    private int samePackageMatchingDepth = 2;
    private final List<ImportDetails> importToGroupList = new ArrayList<ImportDetails>();

    public final void setStandardPackageRegExp(String regexp) {
        this.standardPackageRegExp = CommonUtils.createPattern(regexp);
    }

    public final void setThirdPartyPackageRegExp(String regexp) {
        this.thirdPartyPackageRegExp = CommonUtils.createPattern(regexp);
    }

    public final void setSpecialImportsRegExp(String regexp) {
        this.specialImportsRegExp = CommonUtils.createPattern(regexp);
    }

    public final void setSeparateLineBetweenGroups(boolean value) {
        this.separateLineBetweenGroups = value;
    }

    public final void setSortImportsInGroupAlphabetically(boolean value) {
        this.sortImportsInGroupAlphabetically = value;
    }

    public final void setCustomImportOrderRules(String inputCustomImportOrder) {
        this.customImportOrderRules.clear();
        for (String currentState : GROUP_SEPARATOR_PATTERN.split(inputCustomImportOrder)) {
            this.addRulesToList(currentState);
        }
        this.customImportOrderRules.add(NON_GROUP_RULE_GROUP);
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{30, 152, 16};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.importToGroupList.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() == 16) {
            if (this.customImportOrderRules.contains(SAME_PACKAGE_RULE_GROUP)) {
                this.samePackageDomainsRegExp = CustomImportOrderCheck.createSamePackageRegexp(this.samePackageMatchingDepth, ast);
            }
        } else {
            String importFullPath = CustomImportOrderCheck.getFullImportIdent(ast);
            int lineNo = ast.getLineNo();
            boolean isStatic = ast.getType() == 152;
            this.importToGroupList.add(new ImportDetails(importFullPath, lineNo, this.getImportGroup(isStatic, importFullPath), isStatic));
        }
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        if (this.importToGroupList.isEmpty()) {
            return;
        }
        ImportDetails firstImport = this.importToGroupList.get(0);
        String currentGroup = this.getImportGroup(firstImport.isStaticImport(), firstImport.getImportFullPath());
        int currentGroupNumber = this.customImportOrderRules.indexOf(currentGroup);
        String previousImportFromCurrentGroup = null;
        for (ImportDetails importObject : this.importToGroupList) {
            String importGroup = importObject.getImportGroup();
            String fullImportIdent = importObject.getImportFullPath();
            if (importGroup.equals(currentGroup)) {
                if (this.sortImportsInGroupAlphabetically && previousImportFromCurrentGroup != null && CustomImportOrderCheck.compareImports(fullImportIdent, previousImportFromCurrentGroup) < 0) {
                    this.log(importObject.getLineNumber(), MSG_LEX, fullImportIdent, previousImportFromCurrentGroup);
                    continue;
                }
                previousImportFromCurrentGroup = fullImportIdent;
                continue;
            }
            if (this.customImportOrderRules.size() > currentGroupNumber + 1) {
                String nextGroup = this.getNextImportGroup(currentGroupNumber + 1);
                if (importGroup.equals(nextGroup)) {
                    if (this.separateLineBetweenGroups && !this.hasEmptyLineBefore(importObject.getLineNumber())) {
                        this.log(importObject.getLineNumber(), MSG_LINE_SEPARATOR, fullImportIdent);
                    }
                    currentGroup = nextGroup;
                    currentGroupNumber = this.customImportOrderRules.indexOf(nextGroup);
                    previousImportFromCurrentGroup = fullImportIdent;
                    continue;
                }
                this.logWrongImportGroupOrder(importObject.getLineNumber(), importGroup, nextGroup, fullImportIdent);
                continue;
            }
            this.logWrongImportGroupOrder(importObject.getLineNumber(), importGroup, currentGroup, fullImportIdent);
        }
    }

    private void logWrongImportGroupOrder(int currentImportLine, String importGroup, String currentGroupNumber, String fullImportIdent) {
        if (NON_GROUP_RULE_GROUP.equals(importGroup)) {
            this.log(currentImportLine, MSG_NONGROUP_IMPORT, fullImportIdent);
        } else if (NON_GROUP_RULE_GROUP.equals(currentGroupNumber)) {
            this.log(currentImportLine, MSG_NONGROUP_EXPECTED, importGroup, fullImportIdent);
        } else {
            this.log(currentImportLine, MSG_ORDER, importGroup, currentGroupNumber, fullImportIdent);
        }
    }

    private String getNextImportGroup(int currentGroupNumber) {
        int nextGroupNumber = currentGroupNumber;
        while (this.customImportOrderRules.size() > nextGroupNumber + 1 && !this.hasAnyImportInCurrentGroup(this.customImportOrderRules.get(nextGroupNumber))) {
            ++nextGroupNumber;
        }
        return this.customImportOrderRules.get(nextGroupNumber);
    }

    private boolean hasAnyImportInCurrentGroup(String currentGroup) {
        for (ImportDetails currentImport : this.importToGroupList) {
            if (!currentGroup.equals(currentImport.getImportGroup())) continue;
            return true;
        }
        return false;
    }

    private String getImportGroup(boolean isStatic, String importPath) {
        for (String group : this.customImportOrderRules) {
            if (!this.matchesImportGroup(isStatic, importPath, group)) continue;
            return group;
        }
        return NON_GROUP_RULE_GROUP;
    }

    private boolean matchesImportGroup(boolean isStatic, String importPath, String currentGroup) {
        return CustomImportOrderCheck.matchesStaticImportGroup(isStatic, currentGroup) || this.matchesSamePackageImportGroup(isStatic, importPath, currentGroup) || this.matchesSpecialImportsGroup(isStatic, importPath, currentGroup) || this.matchesStandardImportGroup(isStatic, importPath, currentGroup) || this.matchesThirdPartyImportGroup(isStatic, importPath, currentGroup);
    }

    private static boolean matchesStaticImportGroup(boolean isStatic, String currentGroup) {
        return isStatic && STATIC_RULE_GROUP.equals(currentGroup);
    }

    private boolean matchesSamePackageImportGroup(boolean isStatic, String importFullPath, String currentGroup) {
        String importPathTrimmedToSamePackageDepth = CustomImportOrderCheck.getFirstNDomainsFromIdent(this.samePackageMatchingDepth, importFullPath);
        return !isStatic && SAME_PACKAGE_RULE_GROUP.equals(currentGroup) && this.samePackageDomainsRegExp.equals(importPathTrimmedToSamePackageDepth);
    }

    private boolean matchesStandardImportGroup(boolean isStatic, String currentImport, String currentGroup) {
        return !isStatic && STANDARD_JAVA_PACKAGE_RULE_GROUP.equals(currentGroup) && this.standardPackageRegExp.matcher(currentImport).find();
    }

    private boolean matchesSpecialImportsGroup(boolean isStatic, String currentImport, String currentGroup) {
        return !isStatic && SPECIAL_IMPORTS_RULE_GROUP.equals(currentGroup) && this.specialImportsRegExp.matcher(currentImport).find();
    }

    private boolean matchesThirdPartyImportGroup(boolean isStatic, String currentImport, String currentGroup) {
        return !isStatic && THIRD_PARTY_PACKAGE_RULE_GROUP.equals(currentGroup) && this.thirdPartyPackageRegExp.matcher(currentImport).find() && !this.standardPackageRegExp.matcher(currentImport).find() && !this.specialImportsRegExp.matcher(currentImport).find();
    }

    private static int compareImports(String import1, String import2) {
        String import2Token;
        String import1Token;
        int result = 0;
        String separator = "\\.";
        String[] import1Tokens = import1.split("\\.");
        String[] import2Tokens = import2.split("\\.");
        for (int i = 0; i < import1Tokens.length && i != import2Tokens.length && (result = (import1Token = import1Tokens[i]).compareTo(import2Token = import2Tokens[i])) == 0; ++i) {
        }
        return result;
    }

    private boolean hasEmptyLineBefore(int lineNo) {
        String lineBefore = this.getLine(lineNo - 2);
        return lineBefore.trim().isEmpty();
    }

    private static String getFullImportIdent(DetailAST token) {
        if (token == null) {
            return "";
        }
        return FullIdent.createFullIdent(token.findFirstToken(59)).getText();
    }

    private void addRulesToList(String ruleStr) {
        if (STATIC_RULE_GROUP.equals(ruleStr) || THIRD_PARTY_PACKAGE_RULE_GROUP.equals(ruleStr) || STANDARD_JAVA_PACKAGE_RULE_GROUP.equals(ruleStr) || SPECIAL_IMPORTS_RULE_GROUP.equals(ruleStr)) {
            this.customImportOrderRules.add(ruleStr);
        } else if (ruleStr.startsWith(SAME_PACKAGE_RULE_GROUP)) {
            String rule = ruleStr.substring(ruleStr.indexOf(40) + 1, ruleStr.indexOf(41));
            this.samePackageMatchingDepth = Integer.parseInt(rule);
            if (this.samePackageMatchingDepth <= 0) {
                throw new IllegalArgumentException("SAME_PACKAGE rule parameter should be positive integer: " + ruleStr);
            }
            this.customImportOrderRules.add(SAME_PACKAGE_RULE_GROUP);
        } else {
            throw new IllegalStateException("Unexpected rule: " + ruleStr);
        }
    }

    private static String createSamePackageRegexp(int firstPackageDomainsCount, DetailAST packageNode) {
        String packageFullPath = CustomImportOrderCheck.getFullImportIdent(packageNode);
        return CustomImportOrderCheck.getFirstNDomainsFromIdent(firstPackageDomainsCount, packageFullPath);
    }

    private static String getFirstNDomainsFromIdent(int firstPackageDomainsCount, String packageFullPath) {
        StringBuilder builder = new StringBuilder();
        StringTokenizer tokens = new StringTokenizer(packageFullPath, ".");
        for (int count = firstPackageDomainsCount; tokens.hasMoreTokens() && count > 0; --count) {
            builder.append(tokens.nextToken()).append('.');
        }
        return builder.toString();
    }

    private static class ImportDetails {
        private final String importFullPath;
        private final int lineNumber;
        private final String importGroup;
        private final boolean staticImport;

        ImportDetails(String importFullPath, int lineNumber, String importGroup, boolean staticImport) {
            this.importFullPath = importFullPath;
            this.lineNumber = lineNumber;
            this.importGroup = importGroup;
            this.staticImport = staticImport;
        }

        public String getImportFullPath() {
            return this.importFullPath;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getImportGroup() {
            return this.importGroup;
        }

        public boolean isStaticImport() {
            return this.staticImport;
        }
    }
}

