/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.modifier;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ModifierOrderCheck
extends Check {
    public static final String MSG_ANNOTATION_ORDER = "annotation.order";
    public static final String MSG_MODIFIER_ORDER = "mod.order";
    private static final String[] JLS_ORDER = new String[]{"public", "protected", "private", "abstract", "static", "final", "transient", "volatile", "synchronized", "native", "strictfp", "default"};

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{5};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST error;
        ArrayList mods = Lists.newArrayList();
        for (DetailAST modifier = ast.getFirstChild(); modifier != null; modifier = modifier.getNextSibling()) {
            mods.add(modifier);
        }
        if (!mods.isEmpty() && (error = ModifierOrderCheck.checkOrderSuggestedByJLS(mods)) != null) {
            if (error.getType() == 159) {
                this.log(error.getLineNo(), error.getColumnNo(), MSG_ANNOTATION_ORDER, error.getFirstChild().getText() + error.getFirstChild().getNextSibling().getText());
            } else {
                this.log(error.getLineNo(), error.getColumnNo(), MSG_MODIFIER_ORDER, error.getText());
            }
        }
    }

    static DetailAST checkOrderSuggestedByJLS(List<DetailAST> modifiers) {
        DetailAST modifier;
        Iterator<DetailAST> it = modifiers.iterator();
        do {
            modifier = it.next();
        } while (it.hasNext() && modifier.getType() == 159);
        DetailAST offendingModifier = null;
        if (modifier.getType() != 159) {
            int i = 0;
            while (modifier != null) {
                if (modifier.getType() == 159) {
                    offendingModifier = modifier;
                    break;
                }
                while (i < JLS_ORDER.length && !JLS_ORDER[i].equals(modifier.getText())) {
                    ++i;
                }
                if (i == JLS_ORDER.length) {
                    offendingModifier = modifier;
                    break;
                }
                if (it.hasNext()) {
                    modifier = it.next();
                    continue;
                }
                modifier = null;
            }
        }
        return offendingModifier;
    }
}

