/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.FileSourceFileDataSource;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFileDataSource;
import edu.umd.cs.findbugs.ba.ZipSourceFileDataSource;
import edu.umd.cs.findbugs.io.IO;
import edu.umd.cs.findbugs.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.annotation.WillClose;

public class SourceFinder {
    private static final boolean DEBUG = SystemProperties.getBoolean("srcfinder.debug");
    private static final int CACHE_SIZE = 50;
    private List<SourceRepository> repositoryList;
    private Cache cache;
    private Project project;

    SourceRepository makeInMemorySourceRepository(final String url) {
        final BlockingSourceRepository r = new BlockingSourceRepository();
        Util.runInDameonThread(new Runnable(){

            @Override
            public void run() {
                InputStream in = null;
                try {
                    URLConnection connection = new URL(url).openConnection();
                    in = connection.getInputStream();
                    if (SourceFinder.this.getProject().isGuiAvaliable()) {
                        in = SourceFinder.this.getProject().getGuiCallback().getProgressMonitorInputStream(in, connection.getContentLength(), "Downloading project source code...");
                    }
                    if (url.endsWith(".z0p.gz")) {
                        in = new GZIPInputStream(in);
                    }
                    r.setBase(new InMemorySourceRepository(new ZipInputStream(in)));
                }
                catch (IOException e) {
                    if (SourceFinder.this.getProject().isGuiAvaliable()) {
                        SourceFinder.this.getProject().getGuiCallback().setErrorMessage("Unable to load " + url + "; " + e.getMessage());
                    }
                    AnalysisContext.logError("Unable to load " + url, e);
                    Util.closeSilently(in);
                }
            }
        }, "Source loading thread");
        return r;
    }

    SourceRepository makeJarURLConnectionSourceRepository(final String url) throws MalformedURLException, IOException {
        final File file = File.createTempFile("jar_cache", null);
        file.deleteOnExit();
        final BlockingSourceRepository r = new BlockingSourceRepository();
        Util.runInDameonThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                InputStream in = null;
                FileOutputStream out = null;
                try {
                    URLConnection connection = new URL(url).openConnection();
                    if (SourceFinder.this.getProject().isGuiAvaliable()) {
                        int size = connection.getContentLength();
                        in = SourceFinder.this.getProject().getGuiCallback().getProgressMonitorInputStream(connection.getInputStream(), size, "Loading source via url");
                    } else {
                        in = connection.getInputStream();
                    }
                    out = new FileOutputStream(file);
                    IO.copy(in, out);
                    r.setBase(new ZipSourceRepository(new ZipFile(file)));
                }
                catch (IOException iOException) {
                    Util.closeSilently(in);
                    Util.closeSilently(out);
                    catch (Throwable throwable) {
                        Util.closeSilently(in);
                        Util.closeSilently(out);
                        throw throwable;
                    }
                }
                Util.closeSilently(in);
                Util.closeSilently(out);
            }
        }, "Source loading thread");
        return r;
    }

    public SourceFinder(Project project) {
        this.setProject(project);
    }

    public Project getProject() {
        return this.project;
    }

    void setSourceBaseList(Iterable<String> sourceBaseList) {
        for (String repos : sourceBaseList) {
            if (repos.endsWith(".zip") || repos.endsWith(".jar") || repos.endsWith(".z0p.gz")) {
                try {
                    if (repos.startsWith("http:") || repos.startsWith("https:") || repos.startsWith("file:")) {
                        String url = SystemProperties.rewriteURLAccordingToProperties(repos);
                        this.repositoryList.add(this.makeInMemorySourceRepository(url));
                        continue;
                    }
                    this.repositoryList.add(new ZipSourceRepository(new ZipFile(repos)));
                }
                catch (IOException e) {
                    AnalysisContext.logError("Unable to load " + repos, e);
                }
                continue;
            }
            File dir = new File(repos);
            if (dir.canRead() && dir.isDirectory()) {
                this.repositoryList.add(new DirectorySourceRepository(repos));
                continue;
            }
            AnalysisContext.logError("Unable to load " + repos);
        }
    }

    public InputStream openSource(String packageName, String fileName) throws IOException {
        SourceFile sourceFile = this.findSourceFile(packageName, fileName);
        return sourceFile.getInputStream();
    }

    public InputStream openSource(SourceLineAnnotation source) throws IOException {
        SourceFile sourceFile = this.findSourceFile(source);
        return sourceFile.getInputStream();
    }

    public SourceFile findSourceFile(SourceLineAnnotation source) throws IOException {
        return this.findSourceFile(source.getPackageName(), SourceFinder.getOrGuessSourceFile(source));
    }

    public SourceFile findSourceFile(String packageName, String fileName) throws IOException {
        String platformName = SourceFinder.getPlatformName(packageName, fileName);
        String canonicalName = SourceFinder.getCanonicalName(packageName, fileName);
        SourceFile sourceFile = (SourceFile)this.cache.get(canonicalName);
        if (sourceFile != null) {
            return sourceFile;
        }
        if (DEBUG) {
            System.out.println("Trying " + fileName + " in package " + packageName + "...");
        }
        for (SourceRepository repos : this.repositoryList) {
            if (repos instanceof BlockingSourceRepository && !((BlockingSourceRepository)repos).isReady()) continue;
            String string = fileName = repos.isPlatformDependent() ? platformName : canonicalName;
            if (DEBUG) {
                System.out.println("Looking in " + repos + " for " + fileName);
            }
            if (!repos.contains(fileName)) continue;
            sourceFile = new SourceFile(repos.getDataSource(fileName));
            this.cache.put(canonicalName, sourceFile);
            return sourceFile;
        }
        throw new FileNotFoundException("Can't find source file " + fileName);
    }

    public static String getPlatformName(String packageName, String fileName) {
        String platformName = packageName.replace('.', File.separatorChar) + (packageName.length() > 0 ? File.separator : "") + fileName;
        return platformName;
    }

    public static String getPlatformName(SourceLineAnnotation source) {
        return SourceFinder.getPlatformName(source.getPackageName(), SourceFinder.getOrGuessSourceFile(source));
    }

    public static String getCanonicalName(SourceLineAnnotation source) {
        return SourceFinder.getCanonicalName(source.getPackageName(), SourceFinder.getOrGuessSourceFile(source));
    }

    public static String getCanonicalName(String packageName, String fileName) {
        String canonicalName = packageName.replace('.', '/') + (packageName.length() > 0 ? "/" : "") + fileName;
        return canonicalName;
    }

    public static String getOrGuessSourceFile(SourceLineAnnotation source) {
        if (source.isSourceFileKnown()) {
            return source.getSourceFile();
        }
        String baseClassName = source.getClassName();
        int i = baseClassName.lastIndexOf(46);
        int j = (baseClassName = baseClassName.substring(i + 1)).indexOf(36);
        if (j >= 0) {
            baseClassName = baseClassName.substring(0, j);
        }
        return baseClassName + ".java";
    }

    public boolean hasSourceFile(SourceLineAnnotation source) {
        return this.hasSourceFile(source.getPackageName(), SourceFinder.getOrGuessSourceFile(source));
    }

    public boolean hasSourceFile(String packageName, String fileName) {
        String platformName = SourceFinder.getPlatformName(packageName, fileName);
        String canonicalName = SourceFinder.getCanonicalName(packageName, fileName);
        SourceFile sourceFile = (SourceFile)this.cache.get(canonicalName);
        if (sourceFile != null) {
            return true;
        }
        if (DEBUG) {
            System.out.println("Trying " + fileName + " in package " + packageName + "...");
        }
        for (SourceRepository repos : this.repositoryList) {
            if (repos instanceof BlockingSourceRepository && !((BlockingSourceRepository)repos).isReady()) continue;
            String string = fileName = repos.isPlatformDependent() ? platformName : canonicalName;
            if (DEBUG) {
                System.out.println("Looking in " + repos + " for " + fileName);
            }
            if (!repos.contains(fileName)) continue;
            return true;
        }
        return false;
    }

    private void setProject(Project project) {
        this.project = project;
        this.repositoryList = new LinkedList<SourceRepository>();
        this.cache = new Cache();
        this.setSourceBaseList(project.getResolvedSourcePaths());
    }

    static class ZipSourceRepository
    implements SourceRepository {
        ZipFile zipFile;

        public ZipSourceRepository(ZipFile zipFile) {
            this.zipFile = zipFile;
        }

        @Override
        public boolean contains(String fileName) {
            return this.zipFile.getEntry(fileName) != null;
        }

        @Override
        public boolean isPlatformDependent() {
            return false;
        }

        @Override
        public SourceFileDataSource getDataSource(String fileName) {
            return new ZipSourceFileDataSource(this.zipFile, fileName);
        }
    }

    static class BlockingSourceRepository
    implements SourceRepository {
        SourceRepository base;
        final CountDownLatch ready = new CountDownLatch(1);

        public boolean isReady() {
            return this.ready.getCount() == 0L;
        }

        public void setBase(SourceRepository base) {
            this.base = base;
            this.ready.countDown();
        }

        private void await() {
            try {
                this.ready.await();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Unexpected interrupt", e);
            }
        }

        @Override
        public boolean contains(String fileName) {
            this.await();
            return this.base.contains(fileName);
        }

        @Override
        public SourceFileDataSource getDataSource(String fileName) {
            this.await();
            return this.base.getDataSource(fileName);
        }

        @Override
        public boolean isPlatformDependent() {
            this.await();
            return this.base.isPlatformDependent();
        }
    }

    private static class InMemorySourceRepository
    implements SourceRepository {
        Map<String, byte[]> contents = new HashMap<String, byte[]>();
        Map<String, Long> lastModified = new HashMap<String, Long>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InMemorySourceRepository(@WillClose ZipInputStream in) throws IOException {
            try {
                ZipEntry e;
                while ((e = in.getNextEntry()) != null) {
                    if (!e.isDirectory()) {
                        String name = e.getName();
                        long size = e.getSize();
                        if (size > Integer.MAX_VALUE) {
                            throw new IOException(name + " is too big at " + size + " bytes");
                        }
                        ByteArrayOutputStream out = size <= 0L ? new ByteArrayOutputStream() : new ByteArrayOutputStream((int)size);
                        GZIPOutputStream gOut = new GZIPOutputStream(out);
                        IO.copy(in, gOut);
                        gOut.close();
                        byte[] data = out.toByteArray();
                        this.contents.put(name, data);
                        this.lastModified.put(name, e.getTime());
                    }
                    in.closeEntry();
                }
            }
            finally {
                Util.closeSilently(in);
            }
        }

        @Override
        public boolean contains(String fileName) {
            return this.contents.containsKey(fileName);
        }

        @Override
        public SourceFileDataSource getDataSource(final String fileName) {
            return new SourceFileDataSource(){

                @Override
                public String getFullFileName() {
                    return fileName;
                }

                @Override
                public InputStream open() throws IOException {
                    return new GZIPInputStream(new ByteArrayInputStream(InMemorySourceRepository.this.contents.get(fileName)));
                }

                @Override
                public long getLastModified() {
                    Long when = InMemorySourceRepository.this.lastModified.get(fileName);
                    if (when == null || when < 0L) {
                        return 0L;
                    }
                    return when;
                }
            };
        }

        @Override
        public boolean isPlatformDependent() {
            return false;
        }
    }

    private static class DirectorySourceRepository
    implements SourceRepository {
        private final String baseDir;

        public DirectorySourceRepository(String baseDir) {
            this.baseDir = baseDir;
        }

        public String toString() {
            return "DirectorySourceRepository:" + this.baseDir;
        }

        @Override
        public boolean contains(String fileName) {
            File file = new File(this.getFullFileName(fileName));
            boolean exists = file.exists();
            if (DEBUG) {
                System.out.println("Exists " + exists + " for " + file);
            }
            return exists;
        }

        @Override
        public boolean isPlatformDependent() {
            return true;
        }

        @Override
        public SourceFileDataSource getDataSource(String fileName) {
            return new FileSourceFileDataSource(this.getFullFileName(fileName));
        }

        private String getFullFileName(String fileName) {
            return this.baseDir + File.separator + fileName;
        }
    }

    private static interface SourceRepository {
        public boolean contains(String var1);

        public boolean isPlatformDependent();

        public SourceFileDataSource getDataSource(String var1);
    }

    private static class Cache
    extends LinkedHashMap<String, SourceFile> {
        private static final long serialVersionUID = 1L;

        private Cache() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, SourceFile> eldest) {
            return this.size() >= 50;
        }
    }
}

