/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.type;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.Hierarchy;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class FieldStoreType {
    private final HashSet<String> typeSignatureSet = new HashSet();
    private ReferenceType loadType;

    public void addTypeSignature(String signature) {
        this.loadType = null;
        this.typeSignatureSet.add(signature);
    }

    public Iterator<String> signatureIterator() {
        return this.typeSignatureSet.iterator();
    }

    public ReferenceType getLoadType(ReferenceType fieldType) {
        if (this.loadType == null) {
            this.computeLoadType(fieldType);
        }
        return this.loadType;
    }

    private void computeLoadType(ReferenceType fieldType) {
        ReferenceType leastSupertype = null;
        Iterator<String> i = this.signatureIterator();
        while (i.hasNext()) {
            try {
                String signature = i.next();
                Type type = Type.getType(signature);
                if (!(type instanceof ReferenceType)) continue;
                if (leastSupertype == null) {
                    leastSupertype = (ReferenceType)type;
                    continue;
                }
                leastSupertype = AnalysisContext.currentAnalysisContext().getSubtypes2().getFirstCommonSuperclass(leastSupertype, (ReferenceType)type);
            }
            catch (ClassFormatException e) {
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass(e);
            }
        }
        try {
            if (leastSupertype != null && Hierarchy.isSubtype(leastSupertype, fieldType)) {
                this.loadType = leastSupertype;
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        if (this.loadType == null) {
            this.loadType = fieldType;
        }
    }
}

