/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine.bcel;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.type.ExceptionSetFactory;
import edu.umd.cs.findbugs.ba.type.TypeAnalysis;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.engine.bcel.AnalysisFactory;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.MethodGen;

public class TypeDataflowFactory
extends AnalysisFactory<TypeDataflow> {
    public TypeDataflowFactory() {
        super("type analysis", TypeDataflow.class);
    }

    @Override
    public TypeDataflow analyze(IAnalysisCache analysisCache, MethodDescriptor descriptor) throws CheckedAnalysisException {
        MethodGen methodGen = this.getMethodGen(analysisCache, descriptor);
        if (methodGen == null) {
            throw new MethodUnprofitableException(descriptor);
        }
        CFG cfg = this.getCFG(analysisCache, descriptor);
        DepthFirstSearch dfs = this.getDepthFirstSearch(analysisCache, descriptor);
        ExceptionSetFactory exceptionSetFactory = this.getExceptionSetFactory(analysisCache, descriptor);
        Method method = this.getMethod(analysisCache, descriptor);
        TypeAnalysis typeAnalysis = new TypeAnalysis(method, methodGen, cfg, dfs, AnalysisContext.currentAnalysisContext().getLookupFailureCallback(), exceptionSetFactory);
        if (AnalysisContext.currentAnalysisContext().getBoolProperty(2)) {
            typeAnalysis.setValueNumberDataflow(this.getValueNumberDataflow(analysisCache, descriptor));
        }
        typeAnalysis.setFieldStoreTypeDatabase(AnalysisContext.currentAnalysisContext().getFieldStoreTypeDatabase());
        TypeDataflow typeDataflow = new TypeDataflow(cfg, typeAnalysis);
        try {
            typeDataflow.execute();
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error performing type dataflow analysis of " + descriptor, e);
            throw e;
        }
        if (TypeAnalysis.DEBUG || ClassContext.DUMP_DATAFLOW_ANALYSIS) {
            ClassContext.dumpTypeDataflow(method, cfg, typeDataflow);
        }
        return typeDataflow;
    }
}

