/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class EmptyZipFileEntry
extends BytecodeScanningDetector
implements StatelessDetector {
    private final BugReporter bugReporter;
    private int sawPutEntry;
    private String streamType;

    public EmptyZipFileEntry(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(JavaClass obj) {
    }

    @Override
    public void visit(Method obj) {
        this.sawPutEntry = -10000;
        this.streamType = "";
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 182 && "putNextEntry".equals(this.getNameConstantOperand())) {
            this.streamType = this.getClassConstantOperand();
            if ("java/util/zip/ZipOutputStream".equals(this.streamType) || "java/util/jar/JarOutputStream".equals(this.streamType)) {
                this.sawPutEntry = this.getPC();
            } else {
                this.streamType = "";
            }
        } else if (this.getPC() - this.sawPutEntry <= 7 && seen == 182 && "closeEntry".equals(this.getNameConstantOperand()) && this.getClassConstantOperand().equals(this.streamType)) {
            this.bugReporter.reportBug(new BugInstance(this, "java/util/zip/ZipOutputStream".equals(this.streamType) ? "AM_CREATES_EMPTY_ZIP_FILE_ENTRY" : "AM_CREATES_EMPTY_JAR_FILE_ENTRY", 2).addClassAndMethod(this).addSourceLine(this));
        }
    }
}

