/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.asm.AbstractFBMethodVisitor;
import edu.umd.cs.findbugs.asm.ClassNodeDetector;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class TestASM
extends ClassNodeDetector {
    public TestASM(BugReporter bugReporter) {
        super(bugReporter);
    }

    public MethodVisitor visitMethod(final int access, final String name, final String desc, String signature, String[] exceptions) {
        if (Character.isUpperCase(name.charAt(0))) {
            BugInstance bug0 = new BugInstance(this, "NM_METHOD_NAMING_CONVENTION", 2).addClass(this).addMethod(this.name, name, desc, access);
            this.bugReporter.reportBug(bug0);
        }
        return new AbstractFBMethodVisitor(){
            int prevOpcode;
            int prevPC;

            public void visitInsn(int opcode) {
                this.prevOpcode = opcode;
                this.prevPC = this.getPC();
            }

            public void visitMethodInsn(int opcode, String owner, String invokedName, String invokedDesc, boolean itf) {
                if (this.prevPC + 1 == this.getPC() && this.prevOpcode == 135 && opcode == 184 && "java/lang/Math".equals(owner) && "ceil".equals(invokedName) && "(D)D".equals(invokedDesc)) {
                    BugInstance bug0 = new BugInstance(TestASM.this, "ICAST_INT_CAST_TO_DOUBLE_PASSED_TO_CEIL", 2);
                    MethodAnnotation methodAnnotation = MethodAnnotation.fromForeignMethod(TestASM.this.name, name, desc, access);
                    bug0.addClass(TestASM.this).addMethod(methodAnnotation);
                    TestASM.this.bugReporter.reportBug(bug0);
                }
            }
        };
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ((access & 8) != 0 && (access & 0x10) != 0 && (access & 1) != 0 && !name.equals(name.toUpperCase())) {
            this.bugReporter.reportBug(new BugInstance(this, "NM_FIELD_NAMING_CONVENTION", 3).addClass(this).addField(this.name, name, desc, access));
        }
        return null;
    }
}

