/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Code;

public class VolatileUsage
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    Set<XField> initializationWrites = new HashSet<XField>();
    Set<XField> otherWrites = new HashSet<XField>();
    IncrementState state = IncrementState.START;
    XField incrementField;

    public VolatileUsage(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept(this);
    }

    @Override
    public void visit(Code obj) {
        this.resetIncrementState();
        super.visit(obj);
    }

    @Override
    public void sawOpcode(int seen) {
        XField f;
        switch (this.state) {
            case START: {
                if (seen != 180 || !this.isVolatile(f = this.getXFieldOperand())) break;
                this.incrementField = f;
                this.state = IncrementState.GETFIELD;
                break;
            }
            case GETFIELD: {
                if (seen == 4 || seen == 10 || seen == 2) {
                    this.state = IncrementState.LOADCONSTANT;
                    break;
                }
                this.resetIncrementState();
                break;
            }
            case LOADCONSTANT: {
                if (seen == 96 || seen == 100 || seen == 97 || seen == 101) {
                    this.state = IncrementState.ADD;
                    break;
                }
                this.resetIncrementState();
                break;
            }
            case ADD: {
                if (seen == 181 && this.incrementField.equals(this.getXFieldOperand())) {
                    this.bugReporter.reportBug(new BugInstance(this, "VO_VOLATILE_INCREMENT", "J".equals(this.incrementField.getSignature()) ? 1 : 2).addClassAndMethod(this).addField(this.incrementField).addSourceLine(this));
                }
                this.resetIncrementState();
            }
        }
        switch (seen) {
            case 179: {
                f = this.getXFieldOperand();
                if (!this.isVolatileArray(f)) {
                    return;
                }
                if ("<clinit>".equals(this.getMethodName())) {
                    this.initializationWrites.add(f);
                    break;
                }
                this.otherWrites.add(f);
                break;
            }
            case 181: {
                f = this.getXFieldOperand();
                if (!this.isVolatileArray(f)) {
                    return;
                }
                if ("<init>".equals(this.getMethodName())) {
                    this.initializationWrites.add(f);
                    break;
                }
                this.otherWrites.add(f);
                break;
            }
        }
    }

    private void resetIncrementState() {
        this.state = IncrementState.START;
        this.incrementField = null;
    }

    @Override
    public void report() {
        Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
        for (XField f : AnalysisContext.currentXFactory().allFields()) {
            if (!this.isVolatileArray(f) || !subtypes2.isApplicationClass(f.getClassDescriptor())) continue;
            int priority = 3;
            if (this.initializationWrites.contains(f) && !this.otherWrites.contains(f)) {
                priority = 2;
            }
            this.bugReporter.reportBug(new BugInstance(this, "VO_VOLATILE_REFERENCE_TO_ARRAY", priority).addClass(f.getClassDescriptor()).addField(f));
        }
    }

    private boolean isVolatile(XField f) {
        return f != null && f.isVolatile();
    }

    private boolean isVolatileArray(XField f) {
        return this.isVolatile(f) && f.getSignature().charAt(0) == '[';
    }

    static enum IncrementState {
        START,
        GETFIELD,
        LOADCONSTANT,
        ADD;

    }
}

