/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.scala.cpd;

import net.sourceforge.pmd.cpd.CpdLexer;
import net.sourceforge.pmd.cpd.TokenFactory;
import net.sourceforge.pmd.cpd.impl.BaseTokenFilter;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.scala.cpd.ScalaTokenAdapter;
import net.sourceforge.pmd.lang.scala.internal.ScalaDialect;
import org.apache.commons.lang3.StringUtils;
import scala.collection.Iterator;
import scala.meta.Dialect;
import scala.meta.inputs.Input;
import scala.meta.inputs.Position;
import scala.meta.internal.tokenizers.ScalametaTokenizer;
import scala.meta.tokenizers.TokenizeException;
import scala.meta.tokenizers.TokenizerOptions;
import scala.meta.tokens.Token;
import scala.meta.tokens.Tokens;

public class ScalaCpdLexer
implements CpdLexer {
    private final Dialect dialect;

    public ScalaCpdLexer(LanguagePropertyBundle bundle) {
        LanguageVersion langVer = bundle.getLanguageVersion();
        this.dialect = ScalaDialect.dialectOf(langVer);
    }

    public void tokenize(TextDocument document, TokenFactory tokenEntries) {
        try {
            ScalaTokenAdapter token;
            String fullCode = document.getText().toString();
            Input.VirtualFile vf = new Input.VirtualFile(document.getFileId().getOriginalPath(), fullCode);
            ScalametaTokenizer tokenizer = new ScalametaTokenizer((Input)vf, this.dialect, TokenizerOptions.implicitTokenizerOptions());
            Tokens tokens = tokenizer.tokenize();
            ScalaTokenManager scalaTokenManager = new ScalaTokenManager((Iterator<Token>)tokens.iterator(), document);
            ScalaTokenFilter filter = new ScalaTokenFilter(scalaTokenManager);
            while ((token = (ScalaTokenAdapter)filter.getNextToken()) != null) {
                if (StringUtils.isEmpty((CharSequence)token.getImage())) continue;
                tokenEntries.recordToken(token.getImage(), token.getReportLocation());
            }
        }
        catch (Exception e) {
            if (e instanceof TokenizeException) {
                TokenizeException tokE = (TokenizeException)e;
                Position pos = tokE.pos();
                throw tokenEntries.makeLexException(pos.startLine() + 1, pos.startColumn() + 1, "Scalameta threw", (Throwable)tokE);
            }
            throw e;
        }
    }

    private static class ScalaTokenManager
    implements TokenManager<ScalaTokenAdapter> {
        private final Iterator<Token> tokenIter;
        private final TextDocument textDocument;
        private static final Class<?>[] SKIPPABLE_TOKENS = new Class[]{Token.Space.class, Token.Tab.class, Token.CR.class, Token.LF.class, Token.FF.class, Token.LFLF.class, Token.EOF.class, Token.Comment.class};
        private ScalaTokenAdapter previousComment = null;

        ScalaTokenManager(Iterator<Token> iterator, TextDocument textDocument) {
            this.tokenIter = iterator;
            this.textDocument = textDocument;
        }

        public ScalaTokenAdapter getNextToken() {
            Token token;
            if (!this.tokenIter.hasNext()) {
                return null;
            }
            do {
                if (!this.isComment(token = (Token)this.tokenIter.next())) continue;
                this.previousComment = new ScalaTokenAdapter(token, this.textDocument, this.previousComment);
            } while (token != null && this.skipToken(token) && this.tokenIter.hasNext());
            return new ScalaTokenAdapter(token, this.textDocument, this.previousComment);
        }

        private boolean skipToken(Token token) {
            boolean skip = false;
            if (token.text() != null) {
                for (Class<?> skipTokenClazz : SKIPPABLE_TOKENS) {
                    skip |= skipTokenClazz.isInstance(token);
                }
            }
            return skip;
        }

        private boolean isComment(Token token) {
            return token instanceof Token.Comment;
        }
    }

    private static class ScalaTokenFilter
    extends BaseTokenFilter<ScalaTokenAdapter> {
        ScalaTokenFilter(TokenManager<ScalaTokenAdapter> tokenManager) {
            super(tokenManager);
        }

        protected boolean shouldStopProcessing(ScalaTokenAdapter currentToken) {
            return currentToken == null;
        }
    }
}

