/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.metrics;

import java.util.function.Function;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.metrics.Metric;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.plsql.metrics.internal.NcssVisitor;
import org.apache.commons.lang3.mutable.MutableInt;

public final class PlsqlMetrics {
    public static final Metric<PLSQLNode, Integer> NCSS = Metric.of(PlsqlMetrics::computeNcss, PlsqlMetrics.isPlsqlNode(), (String)"Non-commenting source statements", (String[])new String[]{"NCSS"});

    private PlsqlMetrics() {
    }

    private static Function<Node, PLSQLNode> isPlsqlNode() {
        return n -> n instanceof PLSQLNode ? (PLSQLNode)n : null;
    }

    private static int computeNcss(PLSQLNode node, MetricOptions ignored) {
        MutableInt result = new MutableInt(0);
        node.acceptVisitor(new NcssVisitor(), result);
        return result.intValue();
    }
}

