/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.rule.design;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.metrics.MetricsUtil;
import net.sourceforge.pmd.lang.plsql.ast.ASTDatatype;
import net.sourceforge.pmd.lang.plsql.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.plsql.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.plsql.ast.ASTGlobal;
import net.sourceforge.pmd.lang.plsql.ast.ASTID;
import net.sourceforge.pmd.lang.plsql.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.plsql.ast.ASTProgramUnit;
import net.sourceforge.pmd.lang.plsql.ast.ExecutableCode;
import net.sourceforge.pmd.lang.plsql.ast.OracleObject;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.plsql.metrics.PlsqlMetrics;
import net.sourceforge.pmd.lang.plsql.rule.AbstractPLSQLRule;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public class NcssCountRule
extends AbstractPLSQLRule {
    private static final PropertyDescriptor<Integer> METHOD_REPORT_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"methodReportLevel").desc("NCSS reporting threshold for methods")).require(NumericConstraints.positive())).defaultValue((Object)40)).build();
    private static final PropertyDescriptor<Integer> OBJECT_REPORT_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"objectReportLevel").desc("NCSS reporting threshold for objects")).require(NumericConstraints.positive())).defaultValue((Object)500)).build();
    private Set<PLSQLNode> alreadyVisitedProgramUnits = new HashSet<PLSQLNode>();

    public NcssCountRule() {
        this.definePropertyDescriptor(METHOD_REPORT_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor(OBJECT_REPORT_LEVEL_DESCRIPTOR);
    }

    public void start(RuleContext ctx) {
        this.alreadyVisitedProgramUnits.clear();
    }

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(OracleObject.class, (Class[])new Class[]{ExecutableCode.class});
    }

    @Override
    public Object visitPlsqlNode(PLSQLNode node, Object data) {
        int methodReportLevel = (Integer)this.getProperty(METHOD_REPORT_LEVEL_DESCRIPTOR);
        int objectReportLevel = (Integer)this.getProperty(OBJECT_REPORT_LEVEL_DESCRIPTOR);
        if (node instanceof ASTProgramUnit && this.alreadyVisitedProgramUnits.contains(node)) {
            return data;
        }
        if (node instanceof ASTProgramUnit && !(node.getParent() instanceof ASTGlobal)) {
            this.visitMethod((ExecutableCode)node, methodReportLevel, (RuleContext)data);
            this.alreadyVisitedProgramUnits.add(node);
            return data;
        }
        if (node instanceof ASTProgramUnit && node.getParent() instanceof ASTGlobal) {
            this.visitObject((OracleObject)node, objectReportLevel, (RuleContext)data);
            this.alreadyVisitedProgramUnits.add(node);
            return data;
        }
        if (node instanceof ExecutableCode) {
            this.visitMethod((ExecutableCode)node, methodReportLevel, (RuleContext)data);
        } else if (node instanceof OracleObject) {
            this.visitObject((OracleObject)node, objectReportLevel, (RuleContext)data);
        } else {
            throw AssertionUtil.shouldNotReachHere((String)("node is not handled: " + node));
        }
        return data;
    }

    private void visitMethod(ExecutableCode node, int level, RuleContext ruleContext) {
        int methodSize;
        if (PlsqlMetrics.NCSS.supports((Node)node) && (methodSize = ((Integer)MetricsUtil.computeMetric(PlsqlMetrics.NCSS, (Node)node)).intValue()) >= level) {
            ruleContext.addViolation((Node)node, new Object[]{node.getXPathNodeName(), this.displaySignature(node), methodSize, level});
        }
    }

    private String displaySignature(ExecutableCode node) {
        StringBuilder sb = new StringBuilder(node.getMethodName());
        sb.append('(');
        sb.append(node.children(ASTMethodDeclarator.class).children(ASTFormalParameters.class).children(ASTFormalParameter.class).toStream().map(p -> {
            String id = ((ASTID)p.firstChild(ASTID.class)).getImage();
            String type = Optional.ofNullable((ASTDatatype)p.firstChild(ASTDatatype.class)).map(ASTDatatype::getTypeImage).orElse("...");
            return id + " " + type;
        }).collect(Collectors.joining(", ")));
        sb.append(')');
        return sb.toString();
    }

    private void visitObject(OracleObject node, int level, RuleContext ruleContext) {
        if (PlsqlMetrics.NCSS.supports((Node)node)) {
            int objectSize = (Integer)MetricsUtil.computeMetric(PlsqlMetrics.NCSS, (Node)node);
            int objectHighest = (int)MetricsUtil.computeStatistics(PlsqlMetrics.NCSS, (Iterable)node.descendants(ExecutableCode.class)).getMax();
            if (objectSize >= level) {
                ruleContext.addViolation((Node)node, new Object[]{node.getXPathNodeName(), node.getObjectName(), objectSize, level + ", highest: " + objectHighest});
            }
        }
    }
}

